/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpaceQueryInfoFB;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceQueryInfoBaseHeaderFB
extends Struct<XrSpaceQueryInfoBaseHeaderFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    protected XrSpaceQueryInfoBaseHeaderFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpaceQueryInfoBaseHeaderFB create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceQueryInfoBaseHeaderFB(address, container);
    }

    public XrSpaceQueryInfoBaseHeaderFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpaceQueryInfoBaseHeaderFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceQueryInfoBaseHeaderFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpaceQueryInfoBaseHeaderFB.nnext(this.address());
    }

    public XrSpaceQueryInfoBaseHeaderFB type(@NativeType(value="XrStructureType") int value) {
        XrSpaceQueryInfoBaseHeaderFB.ntype(this.address(), value);
        return this;
    }

    public XrSpaceQueryInfoBaseHeaderFB next(@NativeType(value="void const *") long value) {
        XrSpaceQueryInfoBaseHeaderFB.nnext(this.address(), value);
        return this;
    }

    public XrSpaceQueryInfoBaseHeaderFB set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSpaceQueryInfoBaseHeaderFB set(XrSpaceQueryInfoBaseHeaderFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpaceQueryInfoBaseHeaderFB malloc() {
        return new XrSpaceQueryInfoBaseHeaderFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpaceQueryInfoBaseHeaderFB calloc() {
        return new XrSpaceQueryInfoBaseHeaderFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpaceQueryInfoBaseHeaderFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpaceQueryInfoBaseHeaderFB(MemoryUtil.memAddress(container), container);
    }

    public static XrSpaceQueryInfoBaseHeaderFB create(long address) {
        return new XrSpaceQueryInfoBaseHeaderFB(address, null);
    }

    public static @Nullable XrSpaceQueryInfoBaseHeaderFB createSafe(long address) {
        return address == 0L ? null : new XrSpaceQueryInfoBaseHeaderFB(address, null);
    }

    public static XrSpaceQueryInfoBaseHeaderFB create(XrSpaceQueryInfoFB value) {
        return new XrSpaceQueryInfoBaseHeaderFB(value.address(), XrSpaceQueryInfoBaseHeaderFB.__getContainer(value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpaceQueryInfoBaseHeaderFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceQueryInfoBaseHeaderFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrSpaceQueryInfoFB.Buffer value) {
        return new Buffer(value.address(), XrSpaceQueryInfoBaseHeaderFB.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrSpaceQueryInfoBaseHeaderFB malloc(MemoryStack stack) {
        return new XrSpaceQueryInfoBaseHeaderFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceQueryInfoBaseHeaderFB calloc(MemoryStack stack) {
        return new XrSpaceQueryInfoBaseHeaderFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrSpaceQueryInfoBaseHeaderFB.__struct(XrSpaceQueryInfoBaseHeaderFB.__member(4), XrSpaceQueryInfoBaseHeaderFB.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceQueryInfoBaseHeaderFB, Buffer>
    implements NativeResource {
        private static final XrSpaceQueryInfoBaseHeaderFB ELEMENT_FACTORY = XrSpaceQueryInfoBaseHeaderFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpaceQueryInfoBaseHeaderFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceQueryInfoBaseHeaderFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpaceQueryInfoBaseHeaderFB.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceQueryInfoBaseHeaderFB.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpaceQueryInfoBaseHeaderFB.nnext(this.address(), value);
            return this;
        }
    }
}

