/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceStorageLocationFilterInfoFB
extends Struct<XrSpaceStorageLocationFilterInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LOCATION;

    protected XrSpaceStorageLocationFilterInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpaceStorageLocationFilterInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceStorageLocationFilterInfoFB(address, container);
    }

    public XrSpaceStorageLocationFilterInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpaceStorageLocationFilterInfoFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceStorageLocationFilterInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpaceStorageLocationFilterInfoFB.nnext(this.address());
    }

    @NativeType(value="XrSpaceStorageLocationFB")
    public int location() {
        return XrSpaceStorageLocationFilterInfoFB.nlocation(this.address());
    }

    public XrSpaceStorageLocationFilterInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrSpaceStorageLocationFilterInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrSpaceStorageLocationFilterInfoFB type$Default() {
        return this.type(1000156003);
    }

    public XrSpaceStorageLocationFilterInfoFB next(@NativeType(value="void const *") long value) {
        XrSpaceStorageLocationFilterInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrSpaceStorageLocationFilterInfoFB location(@NativeType(value="XrSpaceStorageLocationFB") int value) {
        XrSpaceStorageLocationFilterInfoFB.nlocation(this.address(), value);
        return this;
    }

    public XrSpaceStorageLocationFilterInfoFB set(int type, long next, int location) {
        this.type(type);
        this.next(next);
        this.location(location);
        return this;
    }

    public XrSpaceStorageLocationFilterInfoFB set(XrSpaceStorageLocationFilterInfoFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpaceStorageLocationFilterInfoFB malloc() {
        return new XrSpaceStorageLocationFilterInfoFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpaceStorageLocationFilterInfoFB calloc() {
        return new XrSpaceStorageLocationFilterInfoFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpaceStorageLocationFilterInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpaceStorageLocationFilterInfoFB(MemoryUtil.memAddress(container), container);
    }

    public static XrSpaceStorageLocationFilterInfoFB create(long address) {
        return new XrSpaceStorageLocationFilterInfoFB(address, null);
    }

    public static @Nullable XrSpaceStorageLocationFilterInfoFB createSafe(long address) {
        return address == 0L ? null : new XrSpaceStorageLocationFilterInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpaceStorageLocationFilterInfoFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceStorageLocationFilterInfoFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpaceStorageLocationFilterInfoFB malloc(MemoryStack stack) {
        return new XrSpaceStorageLocationFilterInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceStorageLocationFilterInfoFB calloc(MemoryStack stack) {
        return new XrSpaceStorageLocationFilterInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nlocation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOCATION);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nlocation(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LOCATION, value);
    }

    static {
        Struct.Layout layout = XrSpaceStorageLocationFilterInfoFB.__struct(XrSpaceStorageLocationFilterInfoFB.__member(4), XrSpaceStorageLocationFilterInfoFB.__member(POINTER_SIZE), XrSpaceStorageLocationFilterInfoFB.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LOCATION = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceStorageLocationFilterInfoFB, Buffer>
    implements NativeResource {
        private static final XrSpaceStorageLocationFilterInfoFB ELEMENT_FACTORY = XrSpaceStorageLocationFilterInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpaceStorageLocationFilterInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceStorageLocationFilterInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpaceStorageLocationFilterInfoFB.nnext(this.address());
        }

        @NativeType(value="XrSpaceStorageLocationFB")
        public int location() {
            return XrSpaceStorageLocationFilterInfoFB.nlocation(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceStorageLocationFilterInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000156003);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpaceStorageLocationFilterInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer location(@NativeType(value="XrSpaceStorageLocationFB") int value) {
            XrSpaceStorageLocationFilterInfoFB.nlocation(this.address(), value);
            return this;
        }
    }
}

