/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpaceFilterInfoBaseHeaderFB;
import org.lwjgl.openxr.XrUuidEXT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceUuidFilterInfoFB
extends Struct<XrSpaceUuidFilterInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int UUIDCOUNT;
    public static final int UUIDS;

    protected XrSpaceUuidFilterInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpaceUuidFilterInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceUuidFilterInfoFB(address, container);
    }

    public XrSpaceUuidFilterInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpaceUuidFilterInfoFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceUuidFilterInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpaceUuidFilterInfoFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int uuidCount() {
        return XrSpaceUuidFilterInfoFB.nuuidCount(this.address());
    }

    @NativeType(value="XrUuidEXT *")
    public XrUuidEXT.Buffer uuids() {
        return XrSpaceUuidFilterInfoFB.nuuids(this.address());
    }

    public XrSpaceUuidFilterInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrSpaceUuidFilterInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrSpaceUuidFilterInfoFB type$Default() {
        return this.type(1000156054);
    }

    public XrSpaceUuidFilterInfoFB next(@NativeType(value="void const *") long value) {
        XrSpaceUuidFilterInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrSpaceUuidFilterInfoFB uuids(@NativeType(value="XrUuidEXT *") XrUuidEXT.Buffer value) {
        XrSpaceUuidFilterInfoFB.nuuids(this.address(), value);
        return this;
    }

    public XrSpaceUuidFilterInfoFB set(int type, long next, XrUuidEXT.Buffer uuids) {
        this.type(type);
        this.next(next);
        this.uuids(uuids);
        return this;
    }

    public XrSpaceUuidFilterInfoFB set(XrSpaceUuidFilterInfoFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpaceUuidFilterInfoFB malloc() {
        return new XrSpaceUuidFilterInfoFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpaceUuidFilterInfoFB calloc() {
        return new XrSpaceUuidFilterInfoFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpaceUuidFilterInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpaceUuidFilterInfoFB(MemoryUtil.memAddress(container), container);
    }

    public static XrSpaceUuidFilterInfoFB create(long address) {
        return new XrSpaceUuidFilterInfoFB(address, null);
    }

    public static @Nullable XrSpaceUuidFilterInfoFB createSafe(long address) {
        return address == 0L ? null : new XrSpaceUuidFilterInfoFB(address, null);
    }

    public static XrSpaceUuidFilterInfoFB create(XrSpaceFilterInfoBaseHeaderFB value) {
        return new XrSpaceUuidFilterInfoFB(value.address(), XrSpaceUuidFilterInfoFB.__getContainer(value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpaceUuidFilterInfoFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceUuidFilterInfoFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrSpaceFilterInfoBaseHeaderFB.Buffer value) {
        return new Buffer(value.address(), XrSpaceUuidFilterInfoFB.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrSpaceUuidFilterInfoFB malloc(MemoryStack stack) {
        return new XrSpaceUuidFilterInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceUuidFilterInfoFB calloc(MemoryStack stack) {
        return new XrSpaceUuidFilterInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nuuidCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UUIDCOUNT);
    }

    public static XrUuidEXT.Buffer nuuids(long struct) {
        return XrUuidEXT.create(MemoryUtil.memGetAddress(struct + (long)UUIDS), XrSpaceUuidFilterInfoFB.nuuidCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nuuidCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)UUIDCOUNT, value);
    }

    public static void nuuids(long struct, XrUuidEXT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)UUIDS, value.address());
        XrSpaceUuidFilterInfoFB.nuuidCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)UUIDS));
    }

    static {
        Struct.Layout layout = XrSpaceUuidFilterInfoFB.__struct(XrSpaceUuidFilterInfoFB.__member(4), XrSpaceUuidFilterInfoFB.__member(POINTER_SIZE), XrSpaceUuidFilterInfoFB.__member(4), XrSpaceUuidFilterInfoFB.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        UUIDCOUNT = layout.offsetof(2);
        UUIDS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceUuidFilterInfoFB, Buffer>
    implements NativeResource {
        private static final XrSpaceUuidFilterInfoFB ELEMENT_FACTORY = XrSpaceUuidFilterInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpaceUuidFilterInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceUuidFilterInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpaceUuidFilterInfoFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int uuidCount() {
            return XrSpaceUuidFilterInfoFB.nuuidCount(this.address());
        }

        @NativeType(value="XrUuidEXT *")
        public XrUuidEXT.Buffer uuids() {
            return XrSpaceUuidFilterInfoFB.nuuids(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceUuidFilterInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000156054);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpaceUuidFilterInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer uuids(@NativeType(value="XrUuidEXT *") XrUuidEXT.Buffer value) {
            XrSpaceUuidFilterInfoFB.nuuids(this.address(), value);
            return this;
        }
    }
}

