/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpacesLocateInfo
extends Struct<XrSpacesLocateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BASESPACE;
    public static final int TIME;
    public static final int SPACECOUNT;
    public static final int SPACES;

    protected XrSpacesLocateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpacesLocateInfo create(long address, @Nullable ByteBuffer container) {
        return new XrSpacesLocateInfo(address, container);
    }

    public XrSpacesLocateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpacesLocateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpacesLocateInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpacesLocateInfo.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long baseSpace() {
        return XrSpacesLocateInfo.nbaseSpace(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrSpacesLocateInfo.ntime(this.address());
    }

    @NativeType(value="uint32_t")
    public int spaceCount() {
        return XrSpacesLocateInfo.nspaceCount(this.address());
    }

    @NativeType(value="XrSpace const *")
    public PointerBuffer spaces() {
        return XrSpacesLocateInfo.nspaces(this.address());
    }

    public XrSpacesLocateInfo type(@NativeType(value="XrStructureType") int value) {
        XrSpacesLocateInfo.ntype(this.address(), value);
        return this;
    }

    public XrSpacesLocateInfo type$Default() {
        return this.type(1000471000);
    }

    public XrSpacesLocateInfo next(@NativeType(value="void const *") long value) {
        XrSpacesLocateInfo.nnext(this.address(), value);
        return this;
    }

    public XrSpacesLocateInfo baseSpace(XrSpace value) {
        XrSpacesLocateInfo.nbaseSpace(this.address(), value);
        return this;
    }

    public XrSpacesLocateInfo time(@NativeType(value="XrTime") long value) {
        XrSpacesLocateInfo.ntime(this.address(), value);
        return this;
    }

    public XrSpacesLocateInfo spaces(@NativeType(value="XrSpace const *") PointerBuffer value) {
        XrSpacesLocateInfo.nspaces(this.address(), value);
        return this;
    }

    public XrSpacesLocateInfo set(int type, long next, XrSpace baseSpace, long time, PointerBuffer spaces) {
        this.type(type);
        this.next(next);
        this.baseSpace(baseSpace);
        this.time(time);
        this.spaces(spaces);
        return this;
    }

    public XrSpacesLocateInfo set(XrSpacesLocateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpacesLocateInfo malloc() {
        return new XrSpacesLocateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpacesLocateInfo calloc() {
        return new XrSpacesLocateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpacesLocateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpacesLocateInfo(MemoryUtil.memAddress(container), container);
    }

    public static XrSpacesLocateInfo create(long address) {
        return new XrSpacesLocateInfo(address, null);
    }

    public static @Nullable XrSpacesLocateInfo createSafe(long address) {
        return address == 0L ? null : new XrSpacesLocateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpacesLocateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpacesLocateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpacesLocateInfo malloc(MemoryStack stack) {
        return new XrSpacesLocateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpacesLocateInfo calloc(MemoryStack stack) {
        return new XrSpacesLocateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nbaseSpace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BASESPACE);
    }

    public static long ntime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIME);
    }

    public static int nspaceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SPACECOUNT);
    }

    public static PointerBuffer nspaces(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)SPACES), XrSpacesLocateInfo.nspaceCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nbaseSpace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)BASESPACE, value.address());
    }

    public static void ntime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIME, value);
    }

    public static void nspaceCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SPACECOUNT, value);
    }

    public static void nspaces(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)SPACES, MemoryUtil.memAddress(value));
        XrSpacesLocateInfo.nspaceCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)BASESPACE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPACES));
    }

    static {
        Struct.Layout layout = XrSpacesLocateInfo.__struct(XrSpacesLocateInfo.__member(4), XrSpacesLocateInfo.__member(POINTER_SIZE), XrSpacesLocateInfo.__member(POINTER_SIZE), XrSpacesLocateInfo.__member(8), XrSpacesLocateInfo.__member(4), XrSpacesLocateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BASESPACE = layout.offsetof(2);
        TIME = layout.offsetof(3);
        SPACECOUNT = layout.offsetof(4);
        SPACES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrSpacesLocateInfo, Buffer>
    implements NativeResource {
        private static final XrSpacesLocateInfo ELEMENT_FACTORY = XrSpacesLocateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpacesLocateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpacesLocateInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpacesLocateInfo.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long baseSpace() {
            return XrSpacesLocateInfo.nbaseSpace(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrSpacesLocateInfo.ntime(this.address());
        }

        @NativeType(value="uint32_t")
        public int spaceCount() {
            return XrSpacesLocateInfo.nspaceCount(this.address());
        }

        @NativeType(value="XrSpace const *")
        public PointerBuffer spaces() {
            return XrSpacesLocateInfo.nspaces(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpacesLocateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000471000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpacesLocateInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer baseSpace(XrSpace value) {
            XrSpacesLocateInfo.nbaseSpace(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrSpacesLocateInfo.ntime(this.address(), value);
            return this;
        }

        public Buffer spaces(@NativeType(value="XrSpace const *") PointerBuffer value) {
            XrSpacesLocateInfo.nspaces(this.address(), value);
            return this;
        }
    }
}

