/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSpatialAnchorsCreateInfoBaseHeaderML;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpatialAnchorsCreateInfoFromPoseML
extends Struct<XrSpatialAnchorsCreateInfoFromPoseML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BASESPACE;
    public static final int POSEINBASESPACE;
    public static final int TIME;

    protected XrSpatialAnchorsCreateInfoFromPoseML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpatialAnchorsCreateInfoFromPoseML create(long address, @Nullable ByteBuffer container) {
        return new XrSpatialAnchorsCreateInfoFromPoseML(address, container);
    }

    public XrSpatialAnchorsCreateInfoFromPoseML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpatialAnchorsCreateInfoFromPoseML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpatialAnchorsCreateInfoFromPoseML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpatialAnchorsCreateInfoFromPoseML.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long baseSpace() {
        return XrSpatialAnchorsCreateInfoFromPoseML.nbaseSpace(this.address());
    }

    public XrPosef poseInBaseSpace() {
        return XrSpatialAnchorsCreateInfoFromPoseML.nposeInBaseSpace(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrSpatialAnchorsCreateInfoFromPoseML.ntime(this.address());
    }

    public XrSpatialAnchorsCreateInfoFromPoseML type(@NativeType(value="XrStructureType") int value) {
        XrSpatialAnchorsCreateInfoFromPoseML.ntype(this.address(), value);
        return this;
    }

    public XrSpatialAnchorsCreateInfoFromPoseML type$Default() {
        return this.type(1000140000);
    }

    public XrSpatialAnchorsCreateInfoFromPoseML next(@NativeType(value="void const *") long value) {
        XrSpatialAnchorsCreateInfoFromPoseML.nnext(this.address(), value);
        return this;
    }

    public XrSpatialAnchorsCreateInfoFromPoseML baseSpace(XrSpace value) {
        XrSpatialAnchorsCreateInfoFromPoseML.nbaseSpace(this.address(), value);
        return this;
    }

    public XrSpatialAnchorsCreateInfoFromPoseML poseInBaseSpace(XrPosef value) {
        XrSpatialAnchorsCreateInfoFromPoseML.nposeInBaseSpace(this.address(), value);
        return this;
    }

    public XrSpatialAnchorsCreateInfoFromPoseML poseInBaseSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInBaseSpace());
        return this;
    }

    public XrSpatialAnchorsCreateInfoFromPoseML time(@NativeType(value="XrTime") long value) {
        XrSpatialAnchorsCreateInfoFromPoseML.ntime(this.address(), value);
        return this;
    }

    public XrSpatialAnchorsCreateInfoFromPoseML set(int type, long next, XrSpace baseSpace, XrPosef poseInBaseSpace, long time) {
        this.type(type);
        this.next(next);
        this.baseSpace(baseSpace);
        this.poseInBaseSpace(poseInBaseSpace);
        this.time(time);
        return this;
    }

    public XrSpatialAnchorsCreateInfoFromPoseML set(XrSpatialAnchorsCreateInfoFromPoseML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpatialAnchorsCreateInfoFromPoseML malloc() {
        return new XrSpatialAnchorsCreateInfoFromPoseML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpatialAnchorsCreateInfoFromPoseML calloc() {
        return new XrSpatialAnchorsCreateInfoFromPoseML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpatialAnchorsCreateInfoFromPoseML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpatialAnchorsCreateInfoFromPoseML(MemoryUtil.memAddress(container), container);
    }

    public static XrSpatialAnchorsCreateInfoFromPoseML create(long address) {
        return new XrSpatialAnchorsCreateInfoFromPoseML(address, null);
    }

    public static @Nullable XrSpatialAnchorsCreateInfoFromPoseML createSafe(long address) {
        return address == 0L ? null : new XrSpatialAnchorsCreateInfoFromPoseML(address, null);
    }

    public static XrSpatialAnchorsCreateInfoFromPoseML create(XrSpatialAnchorsCreateInfoBaseHeaderML value) {
        return new XrSpatialAnchorsCreateInfoFromPoseML(value.address(), XrSpatialAnchorsCreateInfoFromPoseML.__getContainer(value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpatialAnchorsCreateInfoFromPoseML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpatialAnchorsCreateInfoFromPoseML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrSpatialAnchorsCreateInfoBaseHeaderML.Buffer value) {
        return new Buffer(value.address(), XrSpatialAnchorsCreateInfoFromPoseML.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrSpatialAnchorsCreateInfoFromPoseML malloc(MemoryStack stack) {
        return new XrSpatialAnchorsCreateInfoFromPoseML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpatialAnchorsCreateInfoFromPoseML calloc(MemoryStack stack) {
        return new XrSpatialAnchorsCreateInfoFromPoseML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nbaseSpace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BASESPACE);
    }

    public static XrPosef nposeInBaseSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINBASESPACE);
    }

    public static long ntime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIME);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nbaseSpace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)BASESPACE, value.address());
    }

    public static void nposeInBaseSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSEINBASESPACE, XrPosef.SIZEOF);
    }

    public static void ntime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIME, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)BASESPACE));
    }

    static {
        Struct.Layout layout = XrSpatialAnchorsCreateInfoFromPoseML.__struct(XrSpatialAnchorsCreateInfoFromPoseML.__member(4), XrSpatialAnchorsCreateInfoFromPoseML.__member(POINTER_SIZE), XrSpatialAnchorsCreateInfoFromPoseML.__member(POINTER_SIZE), XrSpatialAnchorsCreateInfoFromPoseML.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrSpatialAnchorsCreateInfoFromPoseML.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BASESPACE = layout.offsetof(2);
        POSEINBASESPACE = layout.offsetof(3);
        TIME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSpatialAnchorsCreateInfoFromPoseML, Buffer>
    implements NativeResource {
        private static final XrSpatialAnchorsCreateInfoFromPoseML ELEMENT_FACTORY = XrSpatialAnchorsCreateInfoFromPoseML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpatialAnchorsCreateInfoFromPoseML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpatialAnchorsCreateInfoFromPoseML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpatialAnchorsCreateInfoFromPoseML.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long baseSpace() {
            return XrSpatialAnchorsCreateInfoFromPoseML.nbaseSpace(this.address());
        }

        public XrPosef poseInBaseSpace() {
            return XrSpatialAnchorsCreateInfoFromPoseML.nposeInBaseSpace(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrSpatialAnchorsCreateInfoFromPoseML.ntime(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpatialAnchorsCreateInfoFromPoseML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000140000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpatialAnchorsCreateInfoFromPoseML.nnext(this.address(), value);
            return this;
        }

        public Buffer baseSpace(XrSpace value) {
            XrSpatialAnchorsCreateInfoFromPoseML.nbaseSpace(this.address(), value);
            return this;
        }

        public Buffer poseInBaseSpace(XrPosef value) {
            XrSpatialAnchorsCreateInfoFromPoseML.nposeInBaseSpace(this.address(), value);
            return this;
        }

        public Buffer poseInBaseSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInBaseSpace());
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrSpatialAnchorsCreateInfoFromPoseML.ntime(this.address(), value);
            return this;
        }
    }
}

