/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpatialGraphNodeSpaceCreateInfoMSFT
extends Struct<XrSpatialGraphNodeSpaceCreateInfoMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int NODETYPE;
    public static final int NODEID;
    public static final int POSE;

    protected XrSpatialGraphNodeSpaceCreateInfoMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpatialGraphNodeSpaceCreateInfoMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSpatialGraphNodeSpaceCreateInfoMSFT(address, container);
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpatialGraphNodeSpaceCreateInfoMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpatialGraphNodeSpaceCreateInfoMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpatialGraphNodeSpaceCreateInfoMSFT.nnext(this.address());
    }

    @NativeType(value="XrSpatialGraphNodeTypeMSFT")
    public int nodeType() {
        return XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeType(this.address());
    }

    @NativeType(value="uint8_t[XR_GUID_SIZE_MSFT]")
    public ByteBuffer nodeId() {
        return XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeId(this.address());
    }

    @NativeType(value="uint8_t")
    public byte nodeId(int index) {
        return XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeId(this.address(), index);
    }

    public XrPosef pose() {
        return XrSpatialGraphNodeSpaceCreateInfoMSFT.npose(this.address());
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSpatialGraphNodeSpaceCreateInfoMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT type$Default() {
        return this.type(1000049000);
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT next(@NativeType(value="void const *") long value) {
        XrSpatialGraphNodeSpaceCreateInfoMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT nodeType(@NativeType(value="XrSpatialGraphNodeTypeMSFT") int value) {
        XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeType(this.address(), value);
        return this;
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT nodeId(@NativeType(value="uint8_t[XR_GUID_SIZE_MSFT]") ByteBuffer value) {
        XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeId(this.address(), value);
        return this;
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT nodeId(int index, @NativeType(value="uint8_t") byte value) {
        XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeId(this.address(), index, value);
        return this;
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT pose(XrPosef value) {
        XrSpatialGraphNodeSpaceCreateInfoMSFT.npose(this.address(), value);
        return this;
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT set(int type, long next, int nodeType, ByteBuffer nodeId, XrPosef pose) {
        this.type(type);
        this.next(next);
        this.nodeType(nodeType);
        this.nodeId(nodeId);
        this.pose(pose);
        return this;
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT set(XrSpatialGraphNodeSpaceCreateInfoMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpatialGraphNodeSpaceCreateInfoMSFT malloc() {
        return new XrSpatialGraphNodeSpaceCreateInfoMSFT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpatialGraphNodeSpaceCreateInfoMSFT calloc() {
        return new XrSpatialGraphNodeSpaceCreateInfoMSFT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpatialGraphNodeSpaceCreateInfoMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpatialGraphNodeSpaceCreateInfoMSFT(MemoryUtil.memAddress(container), container);
    }

    public static XrSpatialGraphNodeSpaceCreateInfoMSFT create(long address) {
        return new XrSpatialGraphNodeSpaceCreateInfoMSFT(address, null);
    }

    public static @Nullable XrSpatialGraphNodeSpaceCreateInfoMSFT createSafe(long address) {
        return address == 0L ? null : new XrSpatialGraphNodeSpaceCreateInfoMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpatialGraphNodeSpaceCreateInfoMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpatialGraphNodeSpaceCreateInfoMSFT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpatialGraphNodeSpaceCreateInfoMSFT malloc(MemoryStack stack) {
        return new XrSpatialGraphNodeSpaceCreateInfoMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpatialGraphNodeSpaceCreateInfoMSFT calloc(MemoryStack stack) {
        return new XrSpatialGraphNodeSpaceCreateInfoMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nnodeType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NODETYPE);
    }

    public static ByteBuffer nnodeId(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NODEID, 16);
    }

    public static byte nnodeId(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)NODEID + Checks.check(index, 16) * 1L);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nnodeType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NODETYPE, value);
    }

    public static void nnodeId(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)NODEID, value.remaining() * 1);
    }

    public static void nnodeId(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)NODEID + Checks.check(index, 16) * 1L, value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSE, XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrSpatialGraphNodeSpaceCreateInfoMSFT.__struct(XrSpatialGraphNodeSpaceCreateInfoMSFT.__member(4), XrSpatialGraphNodeSpaceCreateInfoMSFT.__member(POINTER_SIZE), XrSpatialGraphNodeSpaceCreateInfoMSFT.__member(4), XrSpatialGraphNodeSpaceCreateInfoMSFT.__array(1, 16), XrSpatialGraphNodeSpaceCreateInfoMSFT.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        NODETYPE = layout.offsetof(2);
        NODEID = layout.offsetof(3);
        POSE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSpatialGraphNodeSpaceCreateInfoMSFT, Buffer>
    implements NativeResource {
        private static final XrSpatialGraphNodeSpaceCreateInfoMSFT ELEMENT_FACTORY = XrSpatialGraphNodeSpaceCreateInfoMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpatialGraphNodeSpaceCreateInfoMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpatialGraphNodeSpaceCreateInfoMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpatialGraphNodeSpaceCreateInfoMSFT.nnext(this.address());
        }

        @NativeType(value="XrSpatialGraphNodeTypeMSFT")
        public int nodeType() {
            return XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeType(this.address());
        }

        @NativeType(value="uint8_t[XR_GUID_SIZE_MSFT]")
        public ByteBuffer nodeId() {
            return XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeId(this.address());
        }

        @NativeType(value="uint8_t")
        public byte nodeId(int index) {
            return XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeId(this.address(), index);
        }

        public XrPosef pose() {
            return XrSpatialGraphNodeSpaceCreateInfoMSFT.npose(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpatialGraphNodeSpaceCreateInfoMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000049000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpatialGraphNodeSpaceCreateInfoMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer nodeType(@NativeType(value="XrSpatialGraphNodeTypeMSFT") int value) {
            XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeType(this.address(), value);
            return this;
        }

        public Buffer nodeId(@NativeType(value="uint8_t[XR_GUID_SIZE_MSFT]") ByteBuffer value) {
            XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeId(this.address(), value);
            return this;
        }

        public Buffer nodeId(int index, @NativeType(value="uint8_t") byte value) {
            XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeId(this.address(), index, value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrSpatialGraphNodeSpaceCreateInfoMSFT.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }
    }
}

