/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSwapchainImageWaitInfo
extends Struct<XrSwapchainImageWaitInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int TIMEOUT;

    protected XrSwapchainImageWaitInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSwapchainImageWaitInfo create(long address, @Nullable ByteBuffer container) {
        return new XrSwapchainImageWaitInfo(address, container);
    }

    public XrSwapchainImageWaitInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSwapchainImageWaitInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSwapchainImageWaitInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSwapchainImageWaitInfo.nnext(this.address());
    }

    @NativeType(value="XrDuration")
    public long timeout() {
        return XrSwapchainImageWaitInfo.ntimeout(this.address());
    }

    public XrSwapchainImageWaitInfo type(@NativeType(value="XrStructureType") int value) {
        XrSwapchainImageWaitInfo.ntype(this.address(), value);
        return this;
    }

    public XrSwapchainImageWaitInfo type$Default() {
        return this.type(56);
    }

    public XrSwapchainImageWaitInfo next(@NativeType(value="void const *") long value) {
        XrSwapchainImageWaitInfo.nnext(this.address(), value);
        return this;
    }

    public XrSwapchainImageWaitInfo timeout(@NativeType(value="XrDuration") long value) {
        XrSwapchainImageWaitInfo.ntimeout(this.address(), value);
        return this;
    }

    public XrSwapchainImageWaitInfo set(int type, long next, long timeout) {
        this.type(type);
        this.next(next);
        this.timeout(timeout);
        return this;
    }

    public XrSwapchainImageWaitInfo set(XrSwapchainImageWaitInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSwapchainImageWaitInfo malloc() {
        return new XrSwapchainImageWaitInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSwapchainImageWaitInfo calloc() {
        return new XrSwapchainImageWaitInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSwapchainImageWaitInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSwapchainImageWaitInfo(MemoryUtil.memAddress(container), container);
    }

    public static XrSwapchainImageWaitInfo create(long address) {
        return new XrSwapchainImageWaitInfo(address, null);
    }

    public static @Nullable XrSwapchainImageWaitInfo createSafe(long address) {
        return address == 0L ? null : new XrSwapchainImageWaitInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSwapchainImageWaitInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSwapchainImageWaitInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSwapchainImageWaitInfo malloc(MemoryStack stack) {
        return new XrSwapchainImageWaitInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSwapchainImageWaitInfo calloc(MemoryStack stack) {
        return new XrSwapchainImageWaitInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long ntimeout(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIMEOUT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ntimeout(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIMEOUT, value);
    }

    static {
        Struct.Layout layout = XrSwapchainImageWaitInfo.__struct(XrSwapchainImageWaitInfo.__member(4), XrSwapchainImageWaitInfo.__member(POINTER_SIZE), XrSwapchainImageWaitInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        TIMEOUT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSwapchainImageWaitInfo, Buffer>
    implements NativeResource {
        private static final XrSwapchainImageWaitInfo ELEMENT_FACTORY = XrSwapchainImageWaitInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSwapchainImageWaitInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSwapchainImageWaitInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSwapchainImageWaitInfo.nnext(this.address());
        }

        @NativeType(value="XrDuration")
        public long timeout() {
            return XrSwapchainImageWaitInfo.ntimeout(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSwapchainImageWaitInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(56);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSwapchainImageWaitInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer timeout(@NativeType(value="XrDuration") long value) {
            XrSwapchainImageWaitInfo.ntimeout(this.address(), value);
            return this;
        }
    }
}

