/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSystemFaceTrackingProperties2FB
extends Struct<XrSystemFaceTrackingProperties2FB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SUPPORTSVISUALFACETRACKING;
    public static final int SUPPORTSAUDIOFACETRACKING;

    protected XrSystemFaceTrackingProperties2FB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSystemFaceTrackingProperties2FB create(long address, @Nullable ByteBuffer container) {
        return new XrSystemFaceTrackingProperties2FB(address, container);
    }

    public XrSystemFaceTrackingProperties2FB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSystemFaceTrackingProperties2FB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSystemFaceTrackingProperties2FB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSystemFaceTrackingProperties2FB.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean supportsVisualFaceTracking() {
        return XrSystemFaceTrackingProperties2FB.nsupportsVisualFaceTracking(this.address()) != 0;
    }

    @NativeType(value="XrBool32")
    public boolean supportsAudioFaceTracking() {
        return XrSystemFaceTrackingProperties2FB.nsupportsAudioFaceTracking(this.address()) != 0;
    }

    public XrSystemFaceTrackingProperties2FB type(@NativeType(value="XrStructureType") int value) {
        XrSystemFaceTrackingProperties2FB.ntype(this.address(), value);
        return this;
    }

    public XrSystemFaceTrackingProperties2FB type$Default() {
        return this.type(1000287013);
    }

    public XrSystemFaceTrackingProperties2FB next(@NativeType(value="void *") long value) {
        XrSystemFaceTrackingProperties2FB.nnext(this.address(), value);
        return this;
    }

    public XrSystemFaceTrackingProperties2FB set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSystemFaceTrackingProperties2FB set(XrSystemFaceTrackingProperties2FB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSystemFaceTrackingProperties2FB malloc() {
        return new XrSystemFaceTrackingProperties2FB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSystemFaceTrackingProperties2FB calloc() {
        return new XrSystemFaceTrackingProperties2FB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSystemFaceTrackingProperties2FB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSystemFaceTrackingProperties2FB(MemoryUtil.memAddress(container), container);
    }

    public static XrSystemFaceTrackingProperties2FB create(long address) {
        return new XrSystemFaceTrackingProperties2FB(address, null);
    }

    public static @Nullable XrSystemFaceTrackingProperties2FB createSafe(long address) {
        return address == 0L ? null : new XrSystemFaceTrackingProperties2FB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSystemFaceTrackingProperties2FB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSystemFaceTrackingProperties2FB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSystemFaceTrackingProperties2FB malloc(MemoryStack stack) {
        return new XrSystemFaceTrackingProperties2FB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSystemFaceTrackingProperties2FB calloc(MemoryStack stack) {
        return new XrSystemFaceTrackingProperties2FB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nsupportsVisualFaceTracking(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTSVISUALFACETRACKING);
    }

    public static int nsupportsAudioFaceTracking(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTSAUDIOFACETRACKING);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrSystemFaceTrackingProperties2FB.__struct(XrSystemFaceTrackingProperties2FB.__member(4), XrSystemFaceTrackingProperties2FB.__member(POINTER_SIZE), XrSystemFaceTrackingProperties2FB.__member(4), XrSystemFaceTrackingProperties2FB.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SUPPORTSVISUALFACETRACKING = layout.offsetof(2);
        SUPPORTSAUDIOFACETRACKING = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSystemFaceTrackingProperties2FB, Buffer>
    implements NativeResource {
        private static final XrSystemFaceTrackingProperties2FB ELEMENT_FACTORY = XrSystemFaceTrackingProperties2FB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSystemFaceTrackingProperties2FB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSystemFaceTrackingProperties2FB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSystemFaceTrackingProperties2FB.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean supportsVisualFaceTracking() {
            return XrSystemFaceTrackingProperties2FB.nsupportsVisualFaceTracking(this.address()) != 0;
        }

        @NativeType(value="XrBool32")
        public boolean supportsAudioFaceTracking() {
            return XrSystemFaceTrackingProperties2FB.nsupportsAudioFaceTracking(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSystemFaceTrackingProperties2FB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000287013);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSystemFaceTrackingProperties2FB.nnext(this.address(), value);
            return this;
        }
    }
}

