/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrUuid
extends Struct<XrUuid>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;

    protected XrUuid(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrUuid create(long address, @Nullable ByteBuffer container) {
        return new XrUuid(address, container);
    }

    public XrUuid(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrUuid.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t[XR_UUID_SIZE]")
    public ByteBuffer data() {
        return XrUuid.ndata(this.address());
    }

    @NativeType(value="uint8_t")
    public byte data(int index) {
        return XrUuid.ndata(this.address(), index);
    }

    public XrUuid data(@NativeType(value="uint8_t[XR_UUID_SIZE]") ByteBuffer value) {
        XrUuid.ndata(this.address(), value);
        return this;
    }

    public XrUuid data(int index, @NativeType(value="uint8_t") byte value) {
        XrUuid.ndata(this.address(), index, value);
        return this;
    }

    public XrUuid set(XrUuid src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrUuid malloc() {
        return new XrUuid(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrUuid calloc() {
        return new XrUuid(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrUuid create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrUuid(MemoryUtil.memAddress(container), container);
    }

    public static XrUuid create(long address) {
        return new XrUuid(address, null);
    }

    public static @Nullable XrUuid createSafe(long address) {
        return address == 0L ? null : new XrUuid(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrUuid.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrUuid.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrUuid malloc(MemoryStack stack) {
        return new XrUuid(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrUuid calloc(MemoryStack stack) {
        return new XrUuid(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DATA, 16);
    }

    public static byte ndata(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)DATA + Checks.check(index, 16) * 1L);
    }

    public static void ndata(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)DATA, value.remaining() * 1);
    }

    public static void ndata(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)DATA + Checks.check(index, 16) * 1L, value);
    }

    static {
        Struct.Layout layout = XrUuid.__struct(XrUuid.__array(1, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XrUuid, Buffer>
    implements NativeResource {
        private static final XrUuid ELEMENT_FACTORY = XrUuid.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrUuid getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t[XR_UUID_SIZE]")
        public ByteBuffer data() {
            return XrUuid.ndata(this.address());
        }

        @NativeType(value="uint8_t")
        public byte data(int index) {
            return XrUuid.ndata(this.address(), index);
        }

        public Buffer data(@NativeType(value="uint8_t[XR_UUID_SIZE]") ByteBuffer value) {
            XrUuid.ndata(this.address(), value);
            return this;
        }

        public Buffer data(int index, @NativeType(value="uint8_t") byte value) {
            XrUuid.ndata(this.address(), index, value);
            return this;
        }
    }
}

