/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrVector2f
extends Struct<XrVector2f>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    protected XrVector2f(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrVector2f create(long address, @Nullable ByteBuffer container) {
        return new XrVector2f(address, container);
    }

    public XrVector2f(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrVector2f.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return XrVector2f.nx(this.address());
    }

    public float y() {
        return XrVector2f.ny(this.address());
    }

    public XrVector2f x(float value) {
        XrVector2f.nx(this.address(), value);
        return this;
    }

    public XrVector2f y(float value) {
        XrVector2f.ny(this.address(), value);
        return this;
    }

    public XrVector2f set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public XrVector2f set(XrVector2f src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrVector2f malloc() {
        return new XrVector2f(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrVector2f calloc() {
        return new XrVector2f(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrVector2f create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrVector2f(MemoryUtil.memAddress(container), container);
    }

    public static XrVector2f create(long address) {
        return new XrVector2f(address, null);
    }

    public static @Nullable XrVector2f createSafe(long address) {
        return address == 0L ? null : new XrVector2f(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrVector2f.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrVector2f.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrVector2f malloc(MemoryStack stack) {
        return new XrVector2f(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrVector2f calloc(MemoryStack stack) {
        return new XrVector2f(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = XrVector2f.__struct(XrVector2f.__member(4), XrVector2f.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrVector2f, Buffer>
    implements NativeResource {
        private static final XrVector2f ELEMENT_FACTORY = XrVector2f.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrVector2f getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return XrVector2f.nx(this.address());
        }

        public float y() {
            return XrVector2f.ny(this.address());
        }

        public Buffer x(float value) {
            XrVector2f.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            XrVector2f.ny(this.address(), value);
            return this;
        }
    }
}

