/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrVector4f
extends Struct<XrVector4f>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;
    public static final int W;

    protected XrVector4f(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrVector4f create(long address, @Nullable ByteBuffer container) {
        return new XrVector4f(address, container);
    }

    public XrVector4f(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrVector4f.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return XrVector4f.nx(this.address());
    }

    public float y() {
        return XrVector4f.ny(this.address());
    }

    public float z() {
        return XrVector4f.nz(this.address());
    }

    public float w() {
        return XrVector4f.nw(this.address());
    }

    public XrVector4f x(float value) {
        XrVector4f.nx(this.address(), value);
        return this;
    }

    public XrVector4f y(float value) {
        XrVector4f.ny(this.address(), value);
        return this;
    }

    public XrVector4f z(float value) {
        XrVector4f.nz(this.address(), value);
        return this;
    }

    public XrVector4f w(float value) {
        XrVector4f.nw(this.address(), value);
        return this;
    }

    public XrVector4f set(float x, float y, float z, float w) {
        this.x(x);
        this.y(y);
        this.z(z);
        this.w(w);
        return this;
    }

    public XrVector4f set(XrVector4f src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrVector4f malloc() {
        return new XrVector4f(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrVector4f calloc() {
        return new XrVector4f(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrVector4f create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrVector4f(MemoryUtil.memAddress(container), container);
    }

    public static XrVector4f create(long address) {
        return new XrVector4f(address, null);
    }

    public static @Nullable XrVector4f createSafe(long address) {
        return address == 0L ? null : new XrVector4f(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrVector4f.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrVector4f.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrVector4f malloc(MemoryStack stack) {
        return new XrVector4f(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrVector4f calloc(MemoryStack stack) {
        return new XrVector4f(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static float nz(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Z);
    }

    public static float nw(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)W);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Z, value);
    }

    public static void nw(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)W, value);
    }

    static {
        Struct.Layout layout = XrVector4f.__struct(XrVector4f.__member(4), XrVector4f.__member(4), XrVector4f.__member(4), XrVector4f.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
        W = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrVector4f, Buffer>
    implements NativeResource {
        private static final XrVector4f ELEMENT_FACTORY = XrVector4f.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrVector4f getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return XrVector4f.nx(this.address());
        }

        public float y() {
            return XrVector4f.ny(this.address());
        }

        public float z() {
            return XrVector4f.nz(this.address());
        }

        public float w() {
            return XrVector4f.nw(this.address());
        }

        public Buffer x(float value) {
            XrVector4f.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            XrVector4f.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            XrVector4f.nz(this.address(), value);
            return this;
        }

        public Buffer w(float value) {
            XrVector4f.nw(this.address(), value);
            return this;
        }
    }
}

