/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrVirtualKeyboardInputInfoMETA
extends Struct<XrVirtualKeyboardInputInfoMETA>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int INPUTSOURCE;
    public static final int INPUTSPACE;
    public static final int INPUTPOSEINSPACE;
    public static final int INPUTSTATE;

    protected XrVirtualKeyboardInputInfoMETA(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrVirtualKeyboardInputInfoMETA create(long address, @Nullable ByteBuffer container) {
        return new XrVirtualKeyboardInputInfoMETA(address, container);
    }

    public XrVirtualKeyboardInputInfoMETA(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrVirtualKeyboardInputInfoMETA.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrVirtualKeyboardInputInfoMETA.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrVirtualKeyboardInputInfoMETA.nnext(this.address());
    }

    @NativeType(value="XrVirtualKeyboardInputSourceMETA")
    public int inputSource() {
        return XrVirtualKeyboardInputInfoMETA.ninputSource(this.address());
    }

    @NativeType(value="XrSpace")
    public @Nullable long inputSpace() {
        return XrVirtualKeyboardInputInfoMETA.ninputSpace(this.address());
    }

    public XrPosef inputPoseInSpace() {
        return XrVirtualKeyboardInputInfoMETA.ninputPoseInSpace(this.address());
    }

    @NativeType(value="XrVirtualKeyboardInputStateFlagsMETA")
    public long inputState() {
        return XrVirtualKeyboardInputInfoMETA.ninputState(this.address());
    }

    public XrVirtualKeyboardInputInfoMETA type(@NativeType(value="XrStructureType") int value) {
        XrVirtualKeyboardInputInfoMETA.ntype(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardInputInfoMETA type$Default() {
        return this.type(1000219010);
    }

    public XrVirtualKeyboardInputInfoMETA next(@NativeType(value="void const *") long value) {
        XrVirtualKeyboardInputInfoMETA.nnext(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardInputInfoMETA inputSource(@NativeType(value="XrVirtualKeyboardInputSourceMETA") int value) {
        XrVirtualKeyboardInputInfoMETA.ninputSource(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardInputInfoMETA inputSpace(@Nullable XrSpace value) {
        XrVirtualKeyboardInputInfoMETA.ninputSpace(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardInputInfoMETA inputPoseInSpace(XrPosef value) {
        XrVirtualKeyboardInputInfoMETA.ninputPoseInSpace(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardInputInfoMETA inputPoseInSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.inputPoseInSpace());
        return this;
    }

    public XrVirtualKeyboardInputInfoMETA inputState(@NativeType(value="XrVirtualKeyboardInputStateFlagsMETA") long value) {
        XrVirtualKeyboardInputInfoMETA.ninputState(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardInputInfoMETA set(int type, long next, int inputSource, XrSpace inputSpace, XrPosef inputPoseInSpace, long inputState) {
        this.type(type);
        this.next(next);
        this.inputSource(inputSource);
        this.inputSpace(inputSpace);
        this.inputPoseInSpace(inputPoseInSpace);
        this.inputState(inputState);
        return this;
    }

    public XrVirtualKeyboardInputInfoMETA set(XrVirtualKeyboardInputInfoMETA src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrVirtualKeyboardInputInfoMETA malloc() {
        return new XrVirtualKeyboardInputInfoMETA(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrVirtualKeyboardInputInfoMETA calloc() {
        return new XrVirtualKeyboardInputInfoMETA(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrVirtualKeyboardInputInfoMETA create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrVirtualKeyboardInputInfoMETA(MemoryUtil.memAddress(container), container);
    }

    public static XrVirtualKeyboardInputInfoMETA create(long address) {
        return new XrVirtualKeyboardInputInfoMETA(address, null);
    }

    public static @Nullable XrVirtualKeyboardInputInfoMETA createSafe(long address) {
        return address == 0L ? null : new XrVirtualKeyboardInputInfoMETA(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrVirtualKeyboardInputInfoMETA.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrVirtualKeyboardInputInfoMETA.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrVirtualKeyboardInputInfoMETA malloc(MemoryStack stack) {
        return new XrVirtualKeyboardInputInfoMETA(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrVirtualKeyboardInputInfoMETA calloc(MemoryStack stack) {
        return new XrVirtualKeyboardInputInfoMETA(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int ninputSource(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INPUTSOURCE);
    }

    public static long ninputSpace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)INPUTSPACE);
    }

    public static XrPosef ninputPoseInSpace(long struct) {
        return XrPosef.create(struct + (long)INPUTPOSEINSPACE);
    }

    public static long ninputState(long struct) {
        return MemoryUtil.memGetLong(struct + (long)INPUTSTATE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ninputSource(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INPUTSOURCE, value);
    }

    public static void ninputSpace(long struct, @Nullable XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)INPUTSPACE, MemoryUtil.memAddressSafe(value));
    }

    public static void ninputPoseInSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)INPUTPOSEINSPACE, XrPosef.SIZEOF);
    }

    public static void ninputState(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)INPUTSTATE, value);
    }

    static {
        Struct.Layout layout = XrVirtualKeyboardInputInfoMETA.__struct(XrVirtualKeyboardInputInfoMETA.__member(4), XrVirtualKeyboardInputInfoMETA.__member(POINTER_SIZE), XrVirtualKeyboardInputInfoMETA.__member(4), XrVirtualKeyboardInputInfoMETA.__member(POINTER_SIZE), XrVirtualKeyboardInputInfoMETA.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrVirtualKeyboardInputInfoMETA.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        INPUTSOURCE = layout.offsetof(2);
        INPUTSPACE = layout.offsetof(3);
        INPUTPOSEINSPACE = layout.offsetof(4);
        INPUTSTATE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrVirtualKeyboardInputInfoMETA, Buffer>
    implements NativeResource {
        private static final XrVirtualKeyboardInputInfoMETA ELEMENT_FACTORY = XrVirtualKeyboardInputInfoMETA.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrVirtualKeyboardInputInfoMETA getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrVirtualKeyboardInputInfoMETA.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrVirtualKeyboardInputInfoMETA.nnext(this.address());
        }

        @NativeType(value="XrVirtualKeyboardInputSourceMETA")
        public int inputSource() {
            return XrVirtualKeyboardInputInfoMETA.ninputSource(this.address());
        }

        @NativeType(value="XrSpace")
        public @Nullable long inputSpace() {
            return XrVirtualKeyboardInputInfoMETA.ninputSpace(this.address());
        }

        public XrPosef inputPoseInSpace() {
            return XrVirtualKeyboardInputInfoMETA.ninputPoseInSpace(this.address());
        }

        @NativeType(value="XrVirtualKeyboardInputStateFlagsMETA")
        public long inputState() {
            return XrVirtualKeyboardInputInfoMETA.ninputState(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrVirtualKeyboardInputInfoMETA.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000219010);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrVirtualKeyboardInputInfoMETA.nnext(this.address(), value);
            return this;
        }

        public Buffer inputSource(@NativeType(value="XrVirtualKeyboardInputSourceMETA") int value) {
            XrVirtualKeyboardInputInfoMETA.ninputSource(this.address(), value);
            return this;
        }

        public Buffer inputSpace(@Nullable XrSpace value) {
            XrVirtualKeyboardInputInfoMETA.ninputSpace(this.address(), value);
            return this;
        }

        public Buffer inputPoseInSpace(XrPosef value) {
            XrVirtualKeyboardInputInfoMETA.ninputPoseInSpace(this.address(), value);
            return this;
        }

        public Buffer inputPoseInSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.inputPoseInSpace());
            return this;
        }

        public Buffer inputState(@NativeType(value="XrVirtualKeyboardInputStateFlagsMETA") long value) {
            XrVirtualKeyboardInputInfoMETA.ninputState(this.address(), value);
            return this;
        }
    }
}

