/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkInstanceCreateInfo;

public class XrVulkanInstanceCreateInfoKHR
extends Struct<XrVulkanInstanceCreateInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SYSTEMID;
    public static final int CREATEFLAGS;
    public static final int PFNGETINSTANCEPROCADDR;
    public static final int VULKANCREATEINFO;
    public static final int VULKANALLOCATOR;

    protected XrVulkanInstanceCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrVulkanInstanceCreateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new XrVulkanInstanceCreateInfoKHR(address, container);
    }

    public XrVulkanInstanceCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrVulkanInstanceCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrVulkanInstanceCreateInfoKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrVulkanInstanceCreateInfoKHR.nnext(this.address());
    }

    @NativeType(value="XrSystemId")
    public long systemId() {
        return XrVulkanInstanceCreateInfoKHR.nsystemId(this.address());
    }

    @NativeType(value="XrVulkanInstanceCreateFlagsKHR")
    public long createFlags() {
        return XrVulkanInstanceCreateInfoKHR.ncreateFlags(this.address());
    }

    @NativeType(value="PFN_vkGetInstanceProcAddr")
    public long pfnGetInstanceProcAddr() {
        return XrVulkanInstanceCreateInfoKHR.npfnGetInstanceProcAddr(this.address());
    }

    @NativeType(value="VkInstanceCreateInfo const *")
    public VkInstanceCreateInfo vulkanCreateInfo() {
        return XrVulkanInstanceCreateInfoKHR.nvulkanCreateInfo(this.address());
    }

    @NativeType(value="VkAllocationCallbacks const *")
    public @Nullable VkAllocationCallbacks vulkanAllocator() {
        return XrVulkanInstanceCreateInfoKHR.nvulkanAllocator(this.address());
    }

    public XrVulkanInstanceCreateInfoKHR type(@NativeType(value="XrStructureType") int value) {
        XrVulkanInstanceCreateInfoKHR.ntype(this.address(), value);
        return this;
    }

    public XrVulkanInstanceCreateInfoKHR type$Default() {
        return this.type(1000090000);
    }

    public XrVulkanInstanceCreateInfoKHR next(@NativeType(value="void const *") long value) {
        XrVulkanInstanceCreateInfoKHR.nnext(this.address(), value);
        return this;
    }

    public XrVulkanInstanceCreateInfoKHR systemId(@NativeType(value="XrSystemId") long value) {
        XrVulkanInstanceCreateInfoKHR.nsystemId(this.address(), value);
        return this;
    }

    public XrVulkanInstanceCreateInfoKHR createFlags(@NativeType(value="XrVulkanInstanceCreateFlagsKHR") long value) {
        XrVulkanInstanceCreateInfoKHR.ncreateFlags(this.address(), value);
        return this;
    }

    public XrVulkanInstanceCreateInfoKHR pfnGetInstanceProcAddr(@NativeType(value="PFN_vkGetInstanceProcAddr") long value) {
        XrVulkanInstanceCreateInfoKHR.npfnGetInstanceProcAddr(this.address(), value);
        return this;
    }

    public XrVulkanInstanceCreateInfoKHR vulkanCreateInfo(@NativeType(value="VkInstanceCreateInfo const *") VkInstanceCreateInfo value) {
        XrVulkanInstanceCreateInfoKHR.nvulkanCreateInfo(this.address(), value);
        return this;
    }

    public XrVulkanInstanceCreateInfoKHR vulkanAllocator(@NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks value) {
        XrVulkanInstanceCreateInfoKHR.nvulkanAllocator(this.address(), value);
        return this;
    }

    public XrVulkanInstanceCreateInfoKHR set(int type, long next, long systemId, long createFlags, long pfnGetInstanceProcAddr, VkInstanceCreateInfo vulkanCreateInfo, @Nullable VkAllocationCallbacks vulkanAllocator) {
        this.type(type);
        this.next(next);
        this.systemId(systemId);
        this.createFlags(createFlags);
        this.pfnGetInstanceProcAddr(pfnGetInstanceProcAddr);
        this.vulkanCreateInfo(vulkanCreateInfo);
        this.vulkanAllocator(vulkanAllocator);
        return this;
    }

    public XrVulkanInstanceCreateInfoKHR set(XrVulkanInstanceCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrVulkanInstanceCreateInfoKHR malloc() {
        return new XrVulkanInstanceCreateInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrVulkanInstanceCreateInfoKHR calloc() {
        return new XrVulkanInstanceCreateInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrVulkanInstanceCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrVulkanInstanceCreateInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static XrVulkanInstanceCreateInfoKHR create(long address) {
        return new XrVulkanInstanceCreateInfoKHR(address, null);
    }

    public static @Nullable XrVulkanInstanceCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : new XrVulkanInstanceCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrVulkanInstanceCreateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrVulkanInstanceCreateInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrVulkanInstanceCreateInfoKHR malloc(MemoryStack stack) {
        return new XrVulkanInstanceCreateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrVulkanInstanceCreateInfoKHR calloc(MemoryStack stack) {
        return new XrVulkanInstanceCreateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nsystemId(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SYSTEMID);
    }

    public static long ncreateFlags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CREATEFLAGS);
    }

    public static long npfnGetInstanceProcAddr(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PFNGETINSTANCEPROCADDR);
    }

    public static VkInstanceCreateInfo nvulkanCreateInfo(long struct) {
        return VkInstanceCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)VULKANCREATEINFO));
    }

    public static @Nullable VkAllocationCallbacks nvulkanAllocator(long struct) {
        return VkAllocationCallbacks.createSafe(MemoryUtil.memGetAddress(struct + (long)VULKANALLOCATOR));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nsystemId(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SYSTEMID, value);
    }

    public static void ncreateFlags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)CREATEFLAGS, value);
    }

    public static void npfnGetInstanceProcAddr(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PFNGETINSTANCEPROCADDR, Checks.check(value));
    }

    public static void nvulkanCreateInfo(long struct, VkInstanceCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)VULKANCREATEINFO, value.address());
    }

    public static void nvulkanAllocator(long struct, @Nullable VkAllocationCallbacks value) {
        MemoryUtil.memPutAddress(struct + (long)VULKANALLOCATOR, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PFNGETINSTANCEPROCADDR));
        long vulkanCreateInfo = MemoryUtil.memGetAddress(struct + (long)VULKANCREATEINFO);
        Checks.check(vulkanCreateInfo);
        VkInstanceCreateInfo.validate(vulkanCreateInfo);
    }

    static {
        Struct.Layout layout = XrVulkanInstanceCreateInfoKHR.__struct(XrVulkanInstanceCreateInfoKHR.__member(4), XrVulkanInstanceCreateInfoKHR.__member(POINTER_SIZE), XrVulkanInstanceCreateInfoKHR.__member(8), XrVulkanInstanceCreateInfoKHR.__member(8), XrVulkanInstanceCreateInfoKHR.__member(POINTER_SIZE), XrVulkanInstanceCreateInfoKHR.__member(POINTER_SIZE), XrVulkanInstanceCreateInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SYSTEMID = layout.offsetof(2);
        CREATEFLAGS = layout.offsetof(3);
        PFNGETINSTANCEPROCADDR = layout.offsetof(4);
        VULKANCREATEINFO = layout.offsetof(5);
        VULKANALLOCATOR = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrVulkanInstanceCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final XrVulkanInstanceCreateInfoKHR ELEMENT_FACTORY = XrVulkanInstanceCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrVulkanInstanceCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrVulkanInstanceCreateInfoKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrVulkanInstanceCreateInfoKHR.nnext(this.address());
        }

        @NativeType(value="XrSystemId")
        public long systemId() {
            return XrVulkanInstanceCreateInfoKHR.nsystemId(this.address());
        }

        @NativeType(value="XrVulkanInstanceCreateFlagsKHR")
        public long createFlags() {
            return XrVulkanInstanceCreateInfoKHR.ncreateFlags(this.address());
        }

        @NativeType(value="PFN_vkGetInstanceProcAddr")
        public long pfnGetInstanceProcAddr() {
            return XrVulkanInstanceCreateInfoKHR.npfnGetInstanceProcAddr(this.address());
        }

        @NativeType(value="VkInstanceCreateInfo const *")
        public VkInstanceCreateInfo vulkanCreateInfo() {
            return XrVulkanInstanceCreateInfoKHR.nvulkanCreateInfo(this.address());
        }

        @NativeType(value="VkAllocationCallbacks const *")
        public @Nullable VkAllocationCallbacks vulkanAllocator() {
            return XrVulkanInstanceCreateInfoKHR.nvulkanAllocator(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrVulkanInstanceCreateInfoKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000090000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrVulkanInstanceCreateInfoKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer systemId(@NativeType(value="XrSystemId") long value) {
            XrVulkanInstanceCreateInfoKHR.nsystemId(this.address(), value);
            return this;
        }

        public Buffer createFlags(@NativeType(value="XrVulkanInstanceCreateFlagsKHR") long value) {
            XrVulkanInstanceCreateInfoKHR.ncreateFlags(this.address(), value);
            return this;
        }

        public Buffer pfnGetInstanceProcAddr(@NativeType(value="PFN_vkGetInstanceProcAddr") long value) {
            XrVulkanInstanceCreateInfoKHR.npfnGetInstanceProcAddr(this.address(), value);
            return this;
        }

        public Buffer vulkanCreateInfo(@NativeType(value="VkInstanceCreateInfo const *") VkInstanceCreateInfo value) {
            XrVulkanInstanceCreateInfoKHR.nvulkanCreateInfo(this.address(), value);
            return this;
        }

        public Buffer vulkanAllocator(@NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks value) {
            XrVulkanInstanceCreateInfoKHR.nvulkanAllocator(this.address(), value);
            return this;
        }
    }
}

