/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrWorldMeshBufferRecommendedSizeInfoML
extends Struct<XrWorldMeshBufferRecommendedSizeInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int MAXBLOCKCOUNT;

    protected XrWorldMeshBufferRecommendedSizeInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrWorldMeshBufferRecommendedSizeInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrWorldMeshBufferRecommendedSizeInfoML(address, container);
    }

    public XrWorldMeshBufferRecommendedSizeInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrWorldMeshBufferRecommendedSizeInfoML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrWorldMeshBufferRecommendedSizeInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrWorldMeshBufferRecommendedSizeInfoML.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxBlockCount() {
        return XrWorldMeshBufferRecommendedSizeInfoML.nmaxBlockCount(this.address());
    }

    public XrWorldMeshBufferRecommendedSizeInfoML type(@NativeType(value="XrStructureType") int value) {
        XrWorldMeshBufferRecommendedSizeInfoML.ntype(this.address(), value);
        return this;
    }

    public XrWorldMeshBufferRecommendedSizeInfoML type$Default() {
        return this.type(1000474005);
    }

    public XrWorldMeshBufferRecommendedSizeInfoML next(@NativeType(value="void const *") long value) {
        XrWorldMeshBufferRecommendedSizeInfoML.nnext(this.address(), value);
        return this;
    }

    public XrWorldMeshBufferRecommendedSizeInfoML maxBlockCount(@NativeType(value="uint32_t") int value) {
        XrWorldMeshBufferRecommendedSizeInfoML.nmaxBlockCount(this.address(), value);
        return this;
    }

    public XrWorldMeshBufferRecommendedSizeInfoML set(int type, long next, int maxBlockCount) {
        this.type(type);
        this.next(next);
        this.maxBlockCount(maxBlockCount);
        return this;
    }

    public XrWorldMeshBufferRecommendedSizeInfoML set(XrWorldMeshBufferRecommendedSizeInfoML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrWorldMeshBufferRecommendedSizeInfoML malloc() {
        return new XrWorldMeshBufferRecommendedSizeInfoML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrWorldMeshBufferRecommendedSizeInfoML calloc() {
        return new XrWorldMeshBufferRecommendedSizeInfoML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrWorldMeshBufferRecommendedSizeInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrWorldMeshBufferRecommendedSizeInfoML(MemoryUtil.memAddress(container), container);
    }

    public static XrWorldMeshBufferRecommendedSizeInfoML create(long address) {
        return new XrWorldMeshBufferRecommendedSizeInfoML(address, null);
    }

    public static @Nullable XrWorldMeshBufferRecommendedSizeInfoML createSafe(long address) {
        return address == 0L ? null : new XrWorldMeshBufferRecommendedSizeInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrWorldMeshBufferRecommendedSizeInfoML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrWorldMeshBufferRecommendedSizeInfoML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrWorldMeshBufferRecommendedSizeInfoML malloc(MemoryStack stack) {
        return new XrWorldMeshBufferRecommendedSizeInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrWorldMeshBufferRecommendedSizeInfoML calloc(MemoryStack stack) {
        return new XrWorldMeshBufferRecommendedSizeInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nmaxBlockCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXBLOCKCOUNT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nmaxBlockCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAXBLOCKCOUNT, value);
    }

    static {
        Struct.Layout layout = XrWorldMeshBufferRecommendedSizeInfoML.__struct(XrWorldMeshBufferRecommendedSizeInfoML.__member(4), XrWorldMeshBufferRecommendedSizeInfoML.__member(POINTER_SIZE), XrWorldMeshBufferRecommendedSizeInfoML.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        MAXBLOCKCOUNT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrWorldMeshBufferRecommendedSizeInfoML, Buffer>
    implements NativeResource {
        private static final XrWorldMeshBufferRecommendedSizeInfoML ELEMENT_FACTORY = XrWorldMeshBufferRecommendedSizeInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrWorldMeshBufferRecommendedSizeInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrWorldMeshBufferRecommendedSizeInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrWorldMeshBufferRecommendedSizeInfoML.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxBlockCount() {
            return XrWorldMeshBufferRecommendedSizeInfoML.nmaxBlockCount(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrWorldMeshBufferRecommendedSizeInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000474005);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrWorldMeshBufferRecommendedSizeInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer maxBlockCount(@NativeType(value="uint32_t") int value) {
            XrWorldMeshBufferRecommendedSizeInfoML.nmaxBlockCount(this.address(), value);
            return this;
        }
    }
}

