/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrWorldMeshBufferSizeML
extends Struct<XrWorldMeshBufferSizeML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SIZE;

    protected XrWorldMeshBufferSizeML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrWorldMeshBufferSizeML create(long address, @Nullable ByteBuffer container) {
        return new XrWorldMeshBufferSizeML(address, container);
    }

    public XrWorldMeshBufferSizeML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrWorldMeshBufferSizeML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrWorldMeshBufferSizeML.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrWorldMeshBufferSizeML.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return XrWorldMeshBufferSizeML.nsize(this.address());
    }

    public XrWorldMeshBufferSizeML type(@NativeType(value="XrStructureType") int value) {
        XrWorldMeshBufferSizeML.ntype(this.address(), value);
        return this;
    }

    public XrWorldMeshBufferSizeML type$Default() {
        return this.type(1000474006);
    }

    public XrWorldMeshBufferSizeML next(@NativeType(value="void *") long value) {
        XrWorldMeshBufferSizeML.nnext(this.address(), value);
        return this;
    }

    public XrWorldMeshBufferSizeML size(@NativeType(value="uint32_t") int value) {
        XrWorldMeshBufferSizeML.nsize(this.address(), value);
        return this;
    }

    public XrWorldMeshBufferSizeML set(int type, long next, int size) {
        this.type(type);
        this.next(next);
        this.size(size);
        return this;
    }

    public XrWorldMeshBufferSizeML set(XrWorldMeshBufferSizeML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrWorldMeshBufferSizeML malloc() {
        return new XrWorldMeshBufferSizeML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrWorldMeshBufferSizeML calloc() {
        return new XrWorldMeshBufferSizeML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrWorldMeshBufferSizeML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrWorldMeshBufferSizeML(MemoryUtil.memAddress(container), container);
    }

    public static XrWorldMeshBufferSizeML create(long address) {
        return new XrWorldMeshBufferSizeML(address, null);
    }

    public static @Nullable XrWorldMeshBufferSizeML createSafe(long address) {
        return address == 0L ? null : new XrWorldMeshBufferSizeML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrWorldMeshBufferSizeML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrWorldMeshBufferSizeML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrWorldMeshBufferSizeML malloc(MemoryStack stack) {
        return new XrWorldMeshBufferSizeML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrWorldMeshBufferSizeML calloc(MemoryStack stack) {
        return new XrWorldMeshBufferSizeML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SIZE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = XrWorldMeshBufferSizeML.__struct(XrWorldMeshBufferSizeML.__member(4), XrWorldMeshBufferSizeML.__member(POINTER_SIZE), XrWorldMeshBufferSizeML.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrWorldMeshBufferSizeML, Buffer>
    implements NativeResource {
        private static final XrWorldMeshBufferSizeML ELEMENT_FACTORY = XrWorldMeshBufferSizeML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrWorldMeshBufferSizeML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrWorldMeshBufferSizeML.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrWorldMeshBufferSizeML.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return XrWorldMeshBufferSizeML.nsize(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrWorldMeshBufferSizeML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000474006);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrWorldMeshBufferSizeML.nnext(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="uint32_t") int value) {
            XrWorldMeshBufferSizeML.nsize(this.address(), value);
            return this;
        }
    }
}

