/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrFutureCompletionBaseHeaderEXT;
import org.lwjgl.openxr.XrWorldMeshBlockML;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrWorldMeshRequestCompletionML
extends Struct<XrWorldMeshRequestCompletionML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FUTURERESULT;
    public static final int BLOCKCOUNT;
    public static final int BLOCKS;

    protected XrWorldMeshRequestCompletionML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrWorldMeshRequestCompletionML create(long address, @Nullable ByteBuffer container) {
        return new XrWorldMeshRequestCompletionML(address, container);
    }

    public XrWorldMeshRequestCompletionML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrWorldMeshRequestCompletionML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrWorldMeshRequestCompletionML.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrWorldMeshRequestCompletionML.nnext(this.address());
    }

    @NativeType(value="XrResult")
    public int futureResult() {
        return XrWorldMeshRequestCompletionML.nfutureResult(this.address());
    }

    @NativeType(value="uint32_t")
    public int blockCount() {
        return XrWorldMeshRequestCompletionML.nblockCount(this.address());
    }

    @NativeType(value="XrWorldMeshBlockML *")
    public XrWorldMeshBlockML.Buffer blocks() {
        return XrWorldMeshRequestCompletionML.nblocks(this.address());
    }

    public XrWorldMeshRequestCompletionML type(@NativeType(value="XrStructureType") int value) {
        XrWorldMeshRequestCompletionML.ntype(this.address(), value);
        return this;
    }

    public XrWorldMeshRequestCompletionML type$Default() {
        return this.type(1000474011);
    }

    public XrWorldMeshRequestCompletionML next(@NativeType(value="void *") long value) {
        XrWorldMeshRequestCompletionML.nnext(this.address(), value);
        return this;
    }

    public XrWorldMeshRequestCompletionML futureResult(@NativeType(value="XrResult") int value) {
        XrWorldMeshRequestCompletionML.nfutureResult(this.address(), value);
        return this;
    }

    public XrWorldMeshRequestCompletionML blocks(@NativeType(value="XrWorldMeshBlockML *") XrWorldMeshBlockML.Buffer value) {
        XrWorldMeshRequestCompletionML.nblocks(this.address(), value);
        return this;
    }

    public XrWorldMeshRequestCompletionML set(int type, long next, int futureResult, XrWorldMeshBlockML.Buffer blocks) {
        this.type(type);
        this.next(next);
        this.futureResult(futureResult);
        this.blocks(blocks);
        return this;
    }

    public XrWorldMeshRequestCompletionML set(XrWorldMeshRequestCompletionML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrWorldMeshRequestCompletionML malloc() {
        return new XrWorldMeshRequestCompletionML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrWorldMeshRequestCompletionML calloc() {
        return new XrWorldMeshRequestCompletionML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrWorldMeshRequestCompletionML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrWorldMeshRequestCompletionML(MemoryUtil.memAddress(container), container);
    }

    public static XrWorldMeshRequestCompletionML create(long address) {
        return new XrWorldMeshRequestCompletionML(address, null);
    }

    public static @Nullable XrWorldMeshRequestCompletionML createSafe(long address) {
        return address == 0L ? null : new XrWorldMeshRequestCompletionML(address, null);
    }

    public static XrWorldMeshRequestCompletionML create(XrFutureCompletionBaseHeaderEXT value) {
        return new XrWorldMeshRequestCompletionML(value.address(), XrWorldMeshRequestCompletionML.__getContainer(value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrWorldMeshRequestCompletionML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrWorldMeshRequestCompletionML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrFutureCompletionBaseHeaderEXT.Buffer value) {
        return new Buffer(value.address(), XrWorldMeshRequestCompletionML.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrWorldMeshRequestCompletionML malloc(MemoryStack stack) {
        return new XrWorldMeshRequestCompletionML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrWorldMeshRequestCompletionML calloc(MemoryStack stack) {
        return new XrWorldMeshRequestCompletionML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nfutureResult(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FUTURERESULT);
    }

    public static int nblockCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BLOCKCOUNT);
    }

    public static XrWorldMeshBlockML.Buffer nblocks(long struct) {
        return XrWorldMeshBlockML.create(MemoryUtil.memGetAddress(struct + (long)BLOCKS), XrWorldMeshRequestCompletionML.nblockCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nfutureResult(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FUTURERESULT, value);
    }

    public static void nblockCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BLOCKCOUNT, value);
    }

    public static void nblocks(long struct, XrWorldMeshBlockML.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)BLOCKS, value.address());
        XrWorldMeshRequestCompletionML.nblockCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        int blockCount = XrWorldMeshRequestCompletionML.nblockCount(struct);
        long blocks = MemoryUtil.memGetAddress(struct + (long)BLOCKS);
        Checks.check(blocks);
        XrWorldMeshRequestCompletionML.validate(blocks, blockCount, XrWorldMeshBlockML.SIZEOF, XrWorldMeshBlockML::validate);
    }

    static {
        Struct.Layout layout = XrWorldMeshRequestCompletionML.__struct(XrWorldMeshRequestCompletionML.__member(4), XrWorldMeshRequestCompletionML.__member(POINTER_SIZE), XrWorldMeshRequestCompletionML.__member(4), XrWorldMeshRequestCompletionML.__member(4), XrWorldMeshRequestCompletionML.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FUTURERESULT = layout.offsetof(2);
        BLOCKCOUNT = layout.offsetof(3);
        BLOCKS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrWorldMeshRequestCompletionML, Buffer>
    implements NativeResource {
        private static final XrWorldMeshRequestCompletionML ELEMENT_FACTORY = XrWorldMeshRequestCompletionML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrWorldMeshRequestCompletionML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrWorldMeshRequestCompletionML.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrWorldMeshRequestCompletionML.nnext(this.address());
        }

        @NativeType(value="XrResult")
        public int futureResult() {
            return XrWorldMeshRequestCompletionML.nfutureResult(this.address());
        }

        @NativeType(value="uint32_t")
        public int blockCount() {
            return XrWorldMeshRequestCompletionML.nblockCount(this.address());
        }

        @NativeType(value="XrWorldMeshBlockML *")
        public XrWorldMeshBlockML.Buffer blocks() {
            return XrWorldMeshRequestCompletionML.nblocks(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrWorldMeshRequestCompletionML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000474011);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrWorldMeshRequestCompletionML.nnext(this.address(), value);
            return this;
        }

        public Buffer futureResult(@NativeType(value="XrResult") int value) {
            XrWorldMeshRequestCompletionML.nfutureResult(this.address(), value);
            return this;
        }

        public Buffer blocks(@NativeType(value="XrWorldMeshBlockML *") XrWorldMeshBlockML.Buffer value) {
            XrWorldMeshRequestCompletionML.nblocks(this.address(), value);
            return this;
        }
    }
}

