/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrAudioChannelData")
public class OVRAudioChannelData
extends Struct<OVRAudioChannelData>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLES;
    public static final int SAMPLESCOUNT;
    public static final int FREQUENCY;

    protected OVRAudioChannelData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVRAudioChannelData create(long address, @Nullable ByteBuffer container) {
        return new OVRAudioChannelData(address, container);
    }

    public OVRAudioChannelData(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVRAudioChannelData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float const *")
    public FloatBuffer Samples() {
        return OVRAudioChannelData.nSamples(this.address());
    }

    public int SamplesCount() {
        return OVRAudioChannelData.nSamplesCount(this.address());
    }

    public int Frequency() {
        return OVRAudioChannelData.nFrequency(this.address());
    }

    public static OVRAudioChannelData malloc() {
        return new OVRAudioChannelData(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVRAudioChannelData calloc() {
        return new OVRAudioChannelData(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVRAudioChannelData create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVRAudioChannelData(MemoryUtil.memAddress(container), container);
    }

    public static OVRAudioChannelData create(long address) {
        return new OVRAudioChannelData(address, null);
    }

    public static @Nullable OVRAudioChannelData createSafe(long address) {
        return address == 0L ? null : new OVRAudioChannelData(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OVRAudioChannelData.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRAudioChannelData.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRAudioChannelData mallocStack() {
        return OVRAudioChannelData.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRAudioChannelData callocStack() {
        return OVRAudioChannelData.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRAudioChannelData mallocStack(MemoryStack stack) {
        return OVRAudioChannelData.malloc(stack);
    }

    @Deprecated
    public static OVRAudioChannelData callocStack(MemoryStack stack) {
        return OVRAudioChannelData.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRAudioChannelData.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRAudioChannelData.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRAudioChannelData.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRAudioChannelData.calloc(capacity, stack);
    }

    public static OVRAudioChannelData malloc(MemoryStack stack) {
        return new OVRAudioChannelData(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRAudioChannelData calloc(MemoryStack stack) {
        return new OVRAudioChannelData(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nSamples(long struct) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)SAMPLES), OVRAudioChannelData.nSamplesCount(struct));
    }

    public static int nSamplesCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLESCOUNT);
    }

    public static int nFrequency(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FREQUENCY);
    }

    static {
        Struct.Layout layout = OVRAudioChannelData.__struct(OVRAudioChannelData.__member(POINTER_SIZE), OVRAudioChannelData.__member(4), OVRAudioChannelData.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLES = layout.offsetof(0);
        SAMPLESCOUNT = layout.offsetof(1);
        FREQUENCY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRAudioChannelData, Buffer>
    implements NativeResource {
        private static final OVRAudioChannelData ELEMENT_FACTORY = OVRAudioChannelData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OVRAudioChannelData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float const *")
        public FloatBuffer Samples() {
            return OVRAudioChannelData.nSamples(this.address());
        }

        public int SamplesCount() {
            return OVRAudioChannelData.nSamplesCount(this.address());
        }

        public int Frequency() {
            return OVRAudioChannelData.nFrequency(this.address());
        }
    }
}

