/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrFovPort")
public class OVRFovPort
extends Struct<OVRFovPort>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int UPTAN;
    public static final int DOWNTAN;
    public static final int LEFTTAN;
    public static final int RIGHTTAN;

    protected OVRFovPort(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVRFovPort create(long address, @Nullable ByteBuffer container) {
        return new OVRFovPort(address, container);
    }

    public OVRFovPort(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVRFovPort.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float UpTan() {
        return OVRFovPort.nUpTan(this.address());
    }

    public float DownTan() {
        return OVRFovPort.nDownTan(this.address());
    }

    public float LeftTan() {
        return OVRFovPort.nLeftTan(this.address());
    }

    public float RightTan() {
        return OVRFovPort.nRightTan(this.address());
    }

    public OVRFovPort UpTan(float value) {
        OVRFovPort.nUpTan(this.address(), value);
        return this;
    }

    public OVRFovPort DownTan(float value) {
        OVRFovPort.nDownTan(this.address(), value);
        return this;
    }

    public OVRFovPort LeftTan(float value) {
        OVRFovPort.nLeftTan(this.address(), value);
        return this;
    }

    public OVRFovPort RightTan(float value) {
        OVRFovPort.nRightTan(this.address(), value);
        return this;
    }

    public OVRFovPort set(float UpTan, float DownTan, float LeftTan, float RightTan) {
        this.UpTan(UpTan);
        this.DownTan(DownTan);
        this.LeftTan(LeftTan);
        this.RightTan(RightTan);
        return this;
    }

    public OVRFovPort set(OVRFovPort src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRFovPort malloc() {
        return new OVRFovPort(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVRFovPort calloc() {
        return new OVRFovPort(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVRFovPort create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVRFovPort(MemoryUtil.memAddress(container), container);
    }

    public static OVRFovPort create(long address) {
        return new OVRFovPort(address, null);
    }

    public static @Nullable OVRFovPort createSafe(long address) {
        return address == 0L ? null : new OVRFovPort(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OVRFovPort.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRFovPort.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRFovPort mallocStack() {
        return OVRFovPort.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRFovPort callocStack() {
        return OVRFovPort.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRFovPort mallocStack(MemoryStack stack) {
        return OVRFovPort.malloc(stack);
    }

    @Deprecated
    public static OVRFovPort callocStack(MemoryStack stack) {
        return OVRFovPort.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRFovPort.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRFovPort.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRFovPort.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRFovPort.calloc(capacity, stack);
    }

    public static OVRFovPort malloc(MemoryStack stack) {
        return new OVRFovPort(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRFovPort calloc(MemoryStack stack) {
        return new OVRFovPort(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nUpTan(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)UPTAN);
    }

    public static float nDownTan(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DOWNTAN);
    }

    public static float nLeftTan(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)LEFTTAN);
    }

    public static float nRightTan(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)RIGHTTAN);
    }

    public static void nUpTan(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)UPTAN, value);
    }

    public static void nDownTan(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)DOWNTAN, value);
    }

    public static void nLeftTan(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)LEFTTAN, value);
    }

    public static void nRightTan(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)RIGHTTAN, value);
    }

    static {
        Struct.Layout layout = OVRFovPort.__struct(OVRFovPort.__member(4), OVRFovPort.__member(4), OVRFovPort.__member(4), OVRFovPort.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        UPTAN = layout.offsetof(0);
        DOWNTAN = layout.offsetof(1);
        LEFTTAN = layout.offsetof(2);
        RIGHTTAN = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OVRFovPort, Buffer>
    implements NativeResource {
        private static final OVRFovPort ELEMENT_FACTORY = OVRFovPort.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OVRFovPort getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float UpTan() {
            return OVRFovPort.nUpTan(this.address());
        }

        public float DownTan() {
            return OVRFovPort.nDownTan(this.address());
        }

        public float LeftTan() {
            return OVRFovPort.nLeftTan(this.address());
        }

        public float RightTan() {
            return OVRFovPort.nRightTan(this.address());
        }

        public Buffer UpTan(float value) {
            OVRFovPort.nUpTan(this.address(), value);
            return this;
        }

        public Buffer DownTan(float value) {
            OVRFovPort.nDownTan(this.address(), value);
            return this;
        }

        public Buffer LeftTan(float value) {
            OVRFovPort.nLeftTan(this.address(), value);
            return this;
        }

        public Buffer RightTan(float value) {
            OVRFovPort.nRightTan(this.address(), value);
            return this;
        }
    }
}

