/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRVector2f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrInputState")
public class OVRInputState
extends Struct<OVRInputState>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TIMEINSECONDS;
    public static final int BUTTONS;
    public static final int TOUCHES;
    public static final int INDEXTRIGGER;
    public static final int HANDTRIGGER;
    public static final int THUMBSTICK;
    public static final int CONTROLLERTYPE;
    public static final int INDEXTRIGGERNODEADZONE;
    public static final int HANDTRIGGERNODEADZONE;
    public static final int THUMBSTICKNODEADZONE;
    public static final int INDEXTRIGGERRAW;
    public static final int HANDTRIGGERRAW;
    public static final int THUMBSTICKRAW;

    protected OVRInputState(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVRInputState create(long address, @Nullable ByteBuffer container) {
        return new OVRInputState(address, container);
    }

    public OVRInputState(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVRInputState.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public double TimeInSeconds() {
        return OVRInputState.nTimeInSeconds(this.address());
    }

    @NativeType(value="unsigned int")
    public int Buttons() {
        return OVRInputState.nButtons(this.address());
    }

    @NativeType(value="unsigned int")
    public int Touches() {
        return OVRInputState.nTouches(this.address());
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer IndexTrigger() {
        return OVRInputState.nIndexTrigger(this.address());
    }

    public float IndexTrigger(int index) {
        return OVRInputState.nIndexTrigger(this.address(), index);
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer HandTrigger() {
        return OVRInputState.nHandTrigger(this.address());
    }

    public float HandTrigger(int index) {
        return OVRInputState.nHandTrigger(this.address(), index);
    }

    @NativeType(value="ovrVector2f[ovrHand_Count]")
    public OVRVector2f.Buffer Thumbstick() {
        return OVRInputState.nThumbstick(this.address());
    }

    @NativeType(value="ovrVector2f")
    public OVRVector2f Thumbstick(int index) {
        return OVRInputState.nThumbstick(this.address(), index);
    }

    @NativeType(value="ovrControllerType")
    public int ControllerType() {
        return OVRInputState.nControllerType(this.address());
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer IndexTriggerNoDeadzone() {
        return OVRInputState.nIndexTriggerNoDeadzone(this.address());
    }

    public float IndexTriggerNoDeadzone(int index) {
        return OVRInputState.nIndexTriggerNoDeadzone(this.address(), index);
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer HandTriggerNoDeadzone() {
        return OVRInputState.nHandTriggerNoDeadzone(this.address());
    }

    public float HandTriggerNoDeadzone(int index) {
        return OVRInputState.nHandTriggerNoDeadzone(this.address(), index);
    }

    @NativeType(value="ovrVector2f[ovrHand_Count]")
    public OVRVector2f.Buffer ThumbstickNoDeadzone() {
        return OVRInputState.nThumbstickNoDeadzone(this.address());
    }

    @NativeType(value="ovrVector2f")
    public OVRVector2f ThumbstickNoDeadzone(int index) {
        return OVRInputState.nThumbstickNoDeadzone(this.address(), index);
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer IndexTriggerRaw() {
        return OVRInputState.nIndexTriggerRaw(this.address());
    }

    public float IndexTriggerRaw(int index) {
        return OVRInputState.nIndexTriggerRaw(this.address(), index);
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer HandTriggerRaw() {
        return OVRInputState.nHandTriggerRaw(this.address());
    }

    public float HandTriggerRaw(int index) {
        return OVRInputState.nHandTriggerRaw(this.address(), index);
    }

    @NativeType(value="ovrVector2f[ovrHand_Count]")
    public OVRVector2f.Buffer ThumbstickRaw() {
        return OVRInputState.nThumbstickRaw(this.address());
    }

    @NativeType(value="ovrVector2f")
    public OVRVector2f ThumbstickRaw(int index) {
        return OVRInputState.nThumbstickRaw(this.address(), index);
    }

    public static OVRInputState malloc() {
        return new OVRInputState(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVRInputState calloc() {
        return new OVRInputState(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVRInputState create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVRInputState(MemoryUtil.memAddress(container), container);
    }

    public static OVRInputState create(long address) {
        return new OVRInputState(address, null);
    }

    public static @Nullable OVRInputState createSafe(long address) {
        return address == 0L ? null : new OVRInputState(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OVRInputState.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRInputState.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRInputState mallocStack() {
        return OVRInputState.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRInputState callocStack() {
        return OVRInputState.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRInputState mallocStack(MemoryStack stack) {
        return OVRInputState.malloc(stack);
    }

    @Deprecated
    public static OVRInputState callocStack(MemoryStack stack) {
        return OVRInputState.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRInputState.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRInputState.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRInputState.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRInputState.calloc(capacity, stack);
    }

    public static OVRInputState malloc(MemoryStack stack) {
        return new OVRInputState(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRInputState calloc(MemoryStack stack) {
        return new OVRInputState(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nTimeInSeconds(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)TIMEINSECONDS);
    }

    public static int nButtons(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BUTTONS);
    }

    public static int nTouches(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TOUCHES);
    }

    public static FloatBuffer nIndexTrigger(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)INDEXTRIGGER, 2);
    }

    public static float nIndexTrigger(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)INDEXTRIGGER + Checks.check(index, 2) * 4L);
    }

    public static FloatBuffer nHandTrigger(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)HANDTRIGGER, 2);
    }

    public static float nHandTrigger(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)HANDTRIGGER + Checks.check(index, 2) * 4L);
    }

    public static OVRVector2f.Buffer nThumbstick(long struct) {
        return OVRVector2f.create(struct + (long)THUMBSTICK, 2);
    }

    public static OVRVector2f nThumbstick(long struct, int index) {
        return OVRVector2f.create(struct + (long)THUMBSTICK + Checks.check(index, 2) * (long)OVRVector2f.SIZEOF);
    }

    public static int nControllerType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CONTROLLERTYPE);
    }

    public static FloatBuffer nIndexTriggerNoDeadzone(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)INDEXTRIGGERNODEADZONE, 2);
    }

    public static float nIndexTriggerNoDeadzone(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)INDEXTRIGGERNODEADZONE + Checks.check(index, 2) * 4L);
    }

    public static FloatBuffer nHandTriggerNoDeadzone(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)HANDTRIGGERNODEADZONE, 2);
    }

    public static float nHandTriggerNoDeadzone(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)HANDTRIGGERNODEADZONE + Checks.check(index, 2) * 4L);
    }

    public static OVRVector2f.Buffer nThumbstickNoDeadzone(long struct) {
        return OVRVector2f.create(struct + (long)THUMBSTICKNODEADZONE, 2);
    }

    public static OVRVector2f nThumbstickNoDeadzone(long struct, int index) {
        return OVRVector2f.create(struct + (long)THUMBSTICKNODEADZONE + Checks.check(index, 2) * (long)OVRVector2f.SIZEOF);
    }

    public static FloatBuffer nIndexTriggerRaw(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)INDEXTRIGGERRAW, 2);
    }

    public static float nIndexTriggerRaw(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)INDEXTRIGGERRAW + Checks.check(index, 2) * 4L);
    }

    public static FloatBuffer nHandTriggerRaw(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)HANDTRIGGERRAW, 2);
    }

    public static float nHandTriggerRaw(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)HANDTRIGGERRAW + Checks.check(index, 2) * 4L);
    }

    public static OVRVector2f.Buffer nThumbstickRaw(long struct) {
        return OVRVector2f.create(struct + (long)THUMBSTICKRAW, 2);
    }

    public static OVRVector2f nThumbstickRaw(long struct, int index) {
        return OVRVector2f.create(struct + (long)THUMBSTICKRAW + Checks.check(index, 2) * (long)OVRVector2f.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRInputState.__struct(OVRInputState.__member(8), OVRInputState.__member(4), OVRInputState.__member(4), OVRInputState.__array(4, 2), OVRInputState.__array(4, 2), OVRInputState.__array(OVRVector2f.SIZEOF, OVRVector2f.ALIGNOF, 2), OVRInputState.__member(4), OVRInputState.__array(4, 2), OVRInputState.__array(4, 2), OVRInputState.__array(OVRVector2f.SIZEOF, OVRVector2f.ALIGNOF, 2), OVRInputState.__array(4, 2), OVRInputState.__array(4, 2), OVRInputState.__array(OVRVector2f.SIZEOF, OVRVector2f.ALIGNOF, 2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TIMEINSECONDS = layout.offsetof(0);
        BUTTONS = layout.offsetof(1);
        TOUCHES = layout.offsetof(2);
        INDEXTRIGGER = layout.offsetof(3);
        HANDTRIGGER = layout.offsetof(4);
        THUMBSTICK = layout.offsetof(5);
        CONTROLLERTYPE = layout.offsetof(6);
        INDEXTRIGGERNODEADZONE = layout.offsetof(7);
        HANDTRIGGERNODEADZONE = layout.offsetof(8);
        THUMBSTICKNODEADZONE = layout.offsetof(9);
        INDEXTRIGGERRAW = layout.offsetof(10);
        HANDTRIGGERRAW = layout.offsetof(11);
        THUMBSTICKRAW = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<OVRInputState, Buffer>
    implements NativeResource {
        private static final OVRInputState ELEMENT_FACTORY = OVRInputState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OVRInputState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double TimeInSeconds() {
            return OVRInputState.nTimeInSeconds(this.address());
        }

        @NativeType(value="unsigned int")
        public int Buttons() {
            return OVRInputState.nButtons(this.address());
        }

        @NativeType(value="unsigned int")
        public int Touches() {
            return OVRInputState.nTouches(this.address());
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer IndexTrigger() {
            return OVRInputState.nIndexTrigger(this.address());
        }

        public float IndexTrigger(int index) {
            return OVRInputState.nIndexTrigger(this.address(), index);
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer HandTrigger() {
            return OVRInputState.nHandTrigger(this.address());
        }

        public float HandTrigger(int index) {
            return OVRInputState.nHandTrigger(this.address(), index);
        }

        @NativeType(value="ovrVector2f[ovrHand_Count]")
        public OVRVector2f.Buffer Thumbstick() {
            return OVRInputState.nThumbstick(this.address());
        }

        @NativeType(value="ovrVector2f")
        public OVRVector2f Thumbstick(int index) {
            return OVRInputState.nThumbstick(this.address(), index);
        }

        @NativeType(value="ovrControllerType")
        public int ControllerType() {
            return OVRInputState.nControllerType(this.address());
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer IndexTriggerNoDeadzone() {
            return OVRInputState.nIndexTriggerNoDeadzone(this.address());
        }

        public float IndexTriggerNoDeadzone(int index) {
            return OVRInputState.nIndexTriggerNoDeadzone(this.address(), index);
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer HandTriggerNoDeadzone() {
            return OVRInputState.nHandTriggerNoDeadzone(this.address());
        }

        public float HandTriggerNoDeadzone(int index) {
            return OVRInputState.nHandTriggerNoDeadzone(this.address(), index);
        }

        @NativeType(value="ovrVector2f[ovrHand_Count]")
        public OVRVector2f.Buffer ThumbstickNoDeadzone() {
            return OVRInputState.nThumbstickNoDeadzone(this.address());
        }

        @NativeType(value="ovrVector2f")
        public OVRVector2f ThumbstickNoDeadzone(int index) {
            return OVRInputState.nThumbstickNoDeadzone(this.address(), index);
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer IndexTriggerRaw() {
            return OVRInputState.nIndexTriggerRaw(this.address());
        }

        public float IndexTriggerRaw(int index) {
            return OVRInputState.nIndexTriggerRaw(this.address(), index);
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer HandTriggerRaw() {
            return OVRInputState.nHandTriggerRaw(this.address());
        }

        public float HandTriggerRaw(int index) {
            return OVRInputState.nHandTriggerRaw(this.address(), index);
        }

        @NativeType(value="ovrVector2f[ovrHand_Count]")
        public OVRVector2f.Buffer ThumbstickRaw() {
            return OVRInputState.nThumbstickRaw(this.address());
        }

        @NativeType(value="ovrVector2f")
        public OVRVector2f ThumbstickRaw(int index) {
            return OVRInputState.nThumbstickRaw(this.address(), index);
        }
    }
}

