/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRQuatf;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrLayerCube")
public class OVRLayerCube
extends Struct<OVRLayerCube>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int ORIENTATION;
    public static final int CUBEMAPTEXTURE;

    protected OVRLayerCube(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVRLayerCube create(long address, @Nullable ByteBuffer container) {
        return new OVRLayerCube(address, container);
    }

    public OVRLayerCube(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVRLayerCube.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerHeader")
    public OVRLayerHeader Header() {
        return OVRLayerCube.nHeader(this.address());
    }

    @NativeType(value="ovrQuatf")
    public OVRQuatf Orientation() {
        return OVRLayerCube.nOrientation(this.address());
    }

    @NativeType(value="ovrTextureSwapChain")
    public long CubeMapTexture() {
        return OVRLayerCube.nCubeMapTexture(this.address());
    }

    public OVRLayerCube Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
        OVRLayerCube.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerCube Header(Consumer<OVRLayerHeader> consumer) {
        consumer.accept(this.Header());
        return this;
    }

    public OVRLayerCube Orientation(@NativeType(value="ovrQuatf") OVRQuatf value) {
        OVRLayerCube.nOrientation(this.address(), value);
        return this;
    }

    public OVRLayerCube Orientation(Consumer<OVRQuatf> consumer) {
        consumer.accept(this.Orientation());
        return this;
    }

    public OVRLayerCube CubeMapTexture(@NativeType(value="ovrTextureSwapChain") long value) {
        OVRLayerCube.nCubeMapTexture(this.address(), value);
        return this;
    }

    public OVRLayerCube set(OVRLayerHeader Header, OVRQuatf Orientation, long CubeMapTexture) {
        this.Header(Header);
        this.Orientation(Orientation);
        this.CubeMapTexture(CubeMapTexture);
        return this;
    }

    public OVRLayerCube set(OVRLayerCube src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRLayerCube malloc() {
        return new OVRLayerCube(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVRLayerCube calloc() {
        return new OVRLayerCube(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVRLayerCube create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVRLayerCube(MemoryUtil.memAddress(container), container);
    }

    public static OVRLayerCube create(long address) {
        return new OVRLayerCube(address, null);
    }

    public static @Nullable OVRLayerCube createSafe(long address) {
        return address == 0L ? null : new OVRLayerCube(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OVRLayerCube.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRLayerCube.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRLayerCube mallocStack() {
        return OVRLayerCube.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerCube callocStack() {
        return OVRLayerCube.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerCube mallocStack(MemoryStack stack) {
        return OVRLayerCube.malloc(stack);
    }

    @Deprecated
    public static OVRLayerCube callocStack(MemoryStack stack) {
        return OVRLayerCube.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRLayerCube.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRLayerCube.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerCube.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerCube.calloc(capacity, stack);
    }

    public static OVRLayerCube malloc(MemoryStack stack) {
        return new OVRLayerCube(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRLayerCube calloc(MemoryStack stack) {
        return new OVRLayerCube(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return OVRLayerHeader.create(struct + (long)HEADER);
    }

    public static OVRQuatf nOrientation(long struct) {
        return OVRQuatf.create(struct + (long)ORIENTATION);
    }

    public static long nCubeMapTexture(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CUBEMAPTEXTURE);
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, OVRLayerHeader.SIZEOF);
    }

    public static void nOrientation(long struct, OVRQuatf value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ORIENTATION, OVRQuatf.SIZEOF);
    }

    public static void nCubeMapTexture(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CUBEMAPTEXTURE, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CUBEMAPTEXTURE));
    }

    static {
        Struct.Layout layout = OVRLayerCube.__struct(OVRLayerCube.__member(OVRLayerHeader.SIZEOF, OVRLayerHeader.ALIGNOF, true), OVRLayerCube.__member(OVRQuatf.SIZEOF, OVRQuatf.ALIGNOF), OVRLayerCube.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        ORIENTATION = layout.offsetof(1);
        CUBEMAPTEXTURE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerCube, Buffer>
    implements NativeResource {
        private static final OVRLayerCube ELEMENT_FACTORY = OVRLayerCube.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OVRLayerCube getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrLayerHeader")
        public OVRLayerHeader Header() {
            return OVRLayerCube.nHeader(this.address());
        }

        @NativeType(value="ovrQuatf")
        public OVRQuatf Orientation() {
            return OVRLayerCube.nOrientation(this.address());
        }

        @NativeType(value="ovrTextureSwapChain")
        public long CubeMapTexture() {
            return OVRLayerCube.nCubeMapTexture(this.address());
        }

        public Buffer Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
            OVRLayerCube.nHeader(this.address(), value);
            return this;
        }

        public Buffer Header(Consumer<OVRLayerHeader> consumer) {
            consumer.accept(this.Header());
            return this;
        }

        public Buffer Orientation(@NativeType(value="ovrQuatf") OVRQuatf value) {
            OVRLayerCube.nOrientation(this.address(), value);
            return this;
        }

        public Buffer Orientation(Consumer<OVRQuatf> consumer) {
            consumer.accept(this.Orientation());
            return this;
        }

        public Buffer CubeMapTexture(@NativeType(value="ovrTextureSwapChain") long value) {
            OVRLayerCube.nCubeMapTexture(this.address(), value);
            return this;
        }
    }
}

