/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRRecti;
import org.lwjgl.ovr.OVRTextureLayoutDescUnion;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrLayerEyeFovMultires")
public class OVRLayerEyeFovMultires
extends Struct<OVRLayerEyeFovMultires>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int COLORTEXTURE;
    public static final int VIEWPORT;
    public static final int FOV;
    public static final int RENDERPOSE;
    public static final int SENSORSAMPLETIME;
    public static final int TEXTURELAYOUT;
    public static final int TEXTURELAYOUTDESC;

    protected OVRLayerEyeFovMultires(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVRLayerEyeFovMultires create(long address, @Nullable ByteBuffer container) {
        return new OVRLayerEyeFovMultires(address, container);
    }

    public OVRLayerEyeFovMultires(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVRLayerEyeFovMultires.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerHeader")
    public OVRLayerHeader Header() {
        return OVRLayerEyeFovMultires.nHeader(this.address());
    }

    @NativeType(value="ovrTextureSwapChain[ovrEye_Count]")
    public PointerBuffer ColorTexture() {
        return OVRLayerEyeFovMultires.nColorTexture(this.address());
    }

    @NativeType(value="ovrTextureSwapChain")
    public long ColorTexture(int index) {
        return OVRLayerEyeFovMultires.nColorTexture(this.address(), index);
    }

    @NativeType(value="ovrRecti[ovrEye_Count]")
    public OVRRecti.Buffer Viewport() {
        return OVRLayerEyeFovMultires.nViewport(this.address());
    }

    @NativeType(value="ovrRecti")
    public OVRRecti Viewport(int index) {
        return OVRLayerEyeFovMultires.nViewport(this.address(), index);
    }

    @NativeType(value="ovrFovPort[ovrEye_Count]")
    public OVRFovPort.Buffer Fov() {
        return OVRLayerEyeFovMultires.nFov(this.address());
    }

    @NativeType(value="ovrFovPort")
    public OVRFovPort Fov(int index) {
        return OVRLayerEyeFovMultires.nFov(this.address(), index);
    }

    @NativeType(value="ovrPosef[ovrEye_Count]")
    public OVRPosef.Buffer RenderPose() {
        return OVRLayerEyeFovMultires.nRenderPose(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef RenderPose(int index) {
        return OVRLayerEyeFovMultires.nRenderPose(this.address(), index);
    }

    public double SensorSampleTime() {
        return OVRLayerEyeFovMultires.nSensorSampleTime(this.address());
    }

    @NativeType(value="ovrTextureLayout")
    public int TextureLayout() {
        return OVRLayerEyeFovMultires.nTextureLayout(this.address());
    }

    @NativeType(value="ovrTextureLayoutDesc_Union")
    public OVRTextureLayoutDescUnion TextureLayoutDesc() {
        return OVRLayerEyeFovMultires.nTextureLayoutDesc(this.address());
    }

    public OVRLayerEyeFovMultires Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
        OVRLayerEyeFovMultires.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovMultires Header(Consumer<OVRLayerHeader> consumer) {
        consumer.accept(this.Header());
        return this;
    }

    public OVRLayerEyeFovMultires ColorTexture(@NativeType(value="ovrTextureSwapChain[ovrEye_Count]") PointerBuffer value) {
        OVRLayerEyeFovMultires.nColorTexture(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovMultires ColorTexture(int index, @NativeType(value="ovrTextureSwapChain") long value) {
        OVRLayerEyeFovMultires.nColorTexture(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFovMultires Viewport(@NativeType(value="ovrRecti[ovrEye_Count]") OVRRecti.Buffer value) {
        OVRLayerEyeFovMultires.nViewport(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovMultires Viewport(int index, @NativeType(value="ovrRecti") OVRRecti value) {
        OVRLayerEyeFovMultires.nViewport(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFovMultires Viewport(Consumer<OVRRecti.Buffer> consumer) {
        consumer.accept(this.Viewport());
        return this;
    }

    public OVRLayerEyeFovMultires Viewport(int index, Consumer<OVRRecti> consumer) {
        consumer.accept(this.Viewport(index));
        return this;
    }

    public OVRLayerEyeFovMultires Fov(@NativeType(value="ovrFovPort[ovrEye_Count]") OVRFovPort.Buffer value) {
        OVRLayerEyeFovMultires.nFov(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovMultires Fov(int index, @NativeType(value="ovrFovPort") OVRFovPort value) {
        OVRLayerEyeFovMultires.nFov(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFovMultires Fov(Consumer<OVRFovPort.Buffer> consumer) {
        consumer.accept(this.Fov());
        return this;
    }

    public OVRLayerEyeFovMultires Fov(int index, Consumer<OVRFovPort> consumer) {
        consumer.accept(this.Fov(index));
        return this;
    }

    public OVRLayerEyeFovMultires RenderPose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
        OVRLayerEyeFovMultires.nRenderPose(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovMultires RenderPose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
        OVRLayerEyeFovMultires.nRenderPose(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFovMultires RenderPose(Consumer<OVRPosef.Buffer> consumer) {
        consumer.accept(this.RenderPose());
        return this;
    }

    public OVRLayerEyeFovMultires RenderPose(int index, Consumer<OVRPosef> consumer) {
        consumer.accept(this.RenderPose(index));
        return this;
    }

    public OVRLayerEyeFovMultires SensorSampleTime(double value) {
        OVRLayerEyeFovMultires.nSensorSampleTime(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovMultires TextureLayout(@NativeType(value="ovrTextureLayout") int value) {
        OVRLayerEyeFovMultires.nTextureLayout(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovMultires TextureLayoutDesc(@NativeType(value="ovrTextureLayoutDesc_Union") OVRTextureLayoutDescUnion value) {
        OVRLayerEyeFovMultires.nTextureLayoutDesc(this.address(), value);
        return this;
    }

    public OVRLayerEyeFovMultires TextureLayoutDesc(Consumer<OVRTextureLayoutDescUnion> consumer) {
        consumer.accept(this.TextureLayoutDesc());
        return this;
    }

    public OVRLayerEyeFovMultires set(OVRLayerHeader Header, PointerBuffer ColorTexture, OVRRecti.Buffer Viewport, OVRFovPort.Buffer Fov, OVRPosef.Buffer RenderPose, double SensorSampleTime, int TextureLayout, OVRTextureLayoutDescUnion TextureLayoutDesc) {
        this.Header(Header);
        this.ColorTexture(ColorTexture);
        this.Viewport(Viewport);
        this.Fov(Fov);
        this.RenderPose(RenderPose);
        this.SensorSampleTime(SensorSampleTime);
        this.TextureLayout(TextureLayout);
        this.TextureLayoutDesc(TextureLayoutDesc);
        return this;
    }

    public OVRLayerEyeFovMultires set(OVRLayerEyeFovMultires src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRLayerEyeFovMultires malloc() {
        return new OVRLayerEyeFovMultires(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVRLayerEyeFovMultires calloc() {
        return new OVRLayerEyeFovMultires(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVRLayerEyeFovMultires create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVRLayerEyeFovMultires(MemoryUtil.memAddress(container), container);
    }

    public static OVRLayerEyeFovMultires create(long address) {
        return new OVRLayerEyeFovMultires(address, null);
    }

    public static @Nullable OVRLayerEyeFovMultires createSafe(long address) {
        return address == 0L ? null : new OVRLayerEyeFovMultires(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OVRLayerEyeFovMultires.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRLayerEyeFovMultires.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRLayerEyeFovMultires mallocStack() {
        return OVRLayerEyeFovMultires.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerEyeFovMultires callocStack() {
        return OVRLayerEyeFovMultires.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerEyeFovMultires mallocStack(MemoryStack stack) {
        return OVRLayerEyeFovMultires.malloc(stack);
    }

    @Deprecated
    public static OVRLayerEyeFovMultires callocStack(MemoryStack stack) {
        return OVRLayerEyeFovMultires.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRLayerEyeFovMultires.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRLayerEyeFovMultires.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerEyeFovMultires.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerEyeFovMultires.calloc(capacity, stack);
    }

    public static OVRLayerEyeFovMultires malloc(MemoryStack stack) {
        return new OVRLayerEyeFovMultires(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRLayerEyeFovMultires calloc(MemoryStack stack) {
        return new OVRLayerEyeFovMultires(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return OVRLayerHeader.create(struct + (long)HEADER);
    }

    public static PointerBuffer nColorTexture(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)COLORTEXTURE, 2);
    }

    public static long nColorTexture(long struct, int index) {
        return MemoryUtil.memGetAddress(struct + (long)COLORTEXTURE + Checks.check(index, 2) * (long)POINTER_SIZE);
    }

    public static OVRRecti.Buffer nViewport(long struct) {
        return OVRRecti.create(struct + (long)VIEWPORT, 2);
    }

    public static OVRRecti nViewport(long struct, int index) {
        return OVRRecti.create(struct + (long)VIEWPORT + Checks.check(index, 2) * (long)OVRRecti.SIZEOF);
    }

    public static OVRFovPort.Buffer nFov(long struct) {
        return OVRFovPort.create(struct + (long)FOV, 2);
    }

    public static OVRFovPort nFov(long struct, int index) {
        return OVRFovPort.create(struct + (long)FOV + Checks.check(index, 2) * (long)OVRFovPort.SIZEOF);
    }

    public static OVRPosef.Buffer nRenderPose(long struct) {
        return OVRPosef.create(struct + (long)RENDERPOSE, 2);
    }

    public static OVRPosef nRenderPose(long struct, int index) {
        return OVRPosef.create(struct + (long)RENDERPOSE + Checks.check(index, 2) * (long)OVRPosef.SIZEOF);
    }

    public static double nSensorSampleTime(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)SENSORSAMPLETIME);
    }

    public static int nTextureLayout(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TEXTURELAYOUT);
    }

    public static OVRTextureLayoutDescUnion nTextureLayoutDesc(long struct) {
        return OVRTextureLayoutDescUnion.create(struct + (long)TEXTURELAYOUTDESC);
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, OVRLayerHeader.SIZEOF);
    }

    public static void nColorTexture(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)COLORTEXTURE, value.remaining() * POINTER_SIZE);
    }

    public static void nColorTexture(long struct, int index, long value) {
        MemoryUtil.memPutAddress(struct + (long)COLORTEXTURE + Checks.check(index, 2) * (long)POINTER_SIZE, value);
    }

    public static void nViewport(long struct, OVRRecti.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)VIEWPORT, value.remaining() * OVRRecti.SIZEOF);
    }

    public static void nViewport(long struct, int index, OVRRecti value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VIEWPORT + Checks.check(index, 2) * (long)OVRRecti.SIZEOF, OVRRecti.SIZEOF);
    }

    public static void nFov(long struct, OVRFovPort.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)FOV, value.remaining() * OVRFovPort.SIZEOF);
    }

    public static void nFov(long struct, int index, OVRFovPort value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FOV + Checks.check(index, 2) * (long)OVRFovPort.SIZEOF, OVRFovPort.SIZEOF);
    }

    public static void nRenderPose(long struct, OVRPosef.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)RENDERPOSE, value.remaining() * OVRPosef.SIZEOF);
    }

    public static void nRenderPose(long struct, int index, OVRPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RENDERPOSE + Checks.check(index, 2) * (long)OVRPosef.SIZEOF, OVRPosef.SIZEOF);
    }

    public static void nSensorSampleTime(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)SENSORSAMPLETIME, value);
    }

    public static void nTextureLayout(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TEXTURELAYOUT, value);
    }

    public static void nTextureLayoutDesc(long struct, OVRTextureLayoutDescUnion value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXTURELAYOUTDESC, OVRTextureLayoutDescUnion.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)COLORTEXTURE));
    }

    static {
        Struct.Layout layout = OVRLayerEyeFovMultires.__struct(OVRLayerEyeFovMultires.__member(OVRLayerHeader.SIZEOF, OVRLayerHeader.ALIGNOF, true), OVRLayerEyeFovMultires.__array(POINTER_SIZE, 2), OVRLayerEyeFovMultires.__array(OVRRecti.SIZEOF, OVRRecti.ALIGNOF, 2), OVRLayerEyeFovMultires.__array(OVRFovPort.SIZEOF, OVRFovPort.ALIGNOF, 2), OVRLayerEyeFovMultires.__array(OVRPosef.SIZEOF, OVRPosef.ALIGNOF, 2), OVRLayerEyeFovMultires.__member(8), OVRLayerEyeFovMultires.__member(4), OVRLayerEyeFovMultires.__member(OVRTextureLayoutDescUnion.SIZEOF, OVRTextureLayoutDescUnion.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        COLORTEXTURE = layout.offsetof(1);
        VIEWPORT = layout.offsetof(2);
        FOV = layout.offsetof(3);
        RENDERPOSE = layout.offsetof(4);
        SENSORSAMPLETIME = layout.offsetof(5);
        TEXTURELAYOUT = layout.offsetof(6);
        TEXTURELAYOUTDESC = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerEyeFovMultires, Buffer>
    implements NativeResource {
        private static final OVRLayerEyeFovMultires ELEMENT_FACTORY = OVRLayerEyeFovMultires.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OVRLayerEyeFovMultires getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrLayerHeader")
        public OVRLayerHeader Header() {
            return OVRLayerEyeFovMultires.nHeader(this.address());
        }

        @NativeType(value="ovrTextureSwapChain[ovrEye_Count]")
        public PointerBuffer ColorTexture() {
            return OVRLayerEyeFovMultires.nColorTexture(this.address());
        }

        @NativeType(value="ovrTextureSwapChain")
        public long ColorTexture(int index) {
            return OVRLayerEyeFovMultires.nColorTexture(this.address(), index);
        }

        @NativeType(value="ovrRecti[ovrEye_Count]")
        public OVRRecti.Buffer Viewport() {
            return OVRLayerEyeFovMultires.nViewport(this.address());
        }

        @NativeType(value="ovrRecti")
        public OVRRecti Viewport(int index) {
            return OVRLayerEyeFovMultires.nViewport(this.address(), index);
        }

        @NativeType(value="ovrFovPort[ovrEye_Count]")
        public OVRFovPort.Buffer Fov() {
            return OVRLayerEyeFovMultires.nFov(this.address());
        }

        @NativeType(value="ovrFovPort")
        public OVRFovPort Fov(int index) {
            return OVRLayerEyeFovMultires.nFov(this.address(), index);
        }

        @NativeType(value="ovrPosef[ovrEye_Count]")
        public OVRPosef.Buffer RenderPose() {
            return OVRLayerEyeFovMultires.nRenderPose(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef RenderPose(int index) {
            return OVRLayerEyeFovMultires.nRenderPose(this.address(), index);
        }

        public double SensorSampleTime() {
            return OVRLayerEyeFovMultires.nSensorSampleTime(this.address());
        }

        @NativeType(value="ovrTextureLayout")
        public int TextureLayout() {
            return OVRLayerEyeFovMultires.nTextureLayout(this.address());
        }

        @NativeType(value="ovrTextureLayoutDesc_Union")
        public OVRTextureLayoutDescUnion TextureLayoutDesc() {
            return OVRLayerEyeFovMultires.nTextureLayoutDesc(this.address());
        }

        public Buffer Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
            OVRLayerEyeFovMultires.nHeader(this.address(), value);
            return this;
        }

        public Buffer Header(Consumer<OVRLayerHeader> consumer) {
            consumer.accept(this.Header());
            return this;
        }

        public Buffer ColorTexture(@NativeType(value="ovrTextureSwapChain[ovrEye_Count]") PointerBuffer value) {
            OVRLayerEyeFovMultires.nColorTexture(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(int index, @NativeType(value="ovrTextureSwapChain") long value) {
            OVRLayerEyeFovMultires.nColorTexture(this.address(), index, value);
            return this;
        }

        public Buffer Viewport(@NativeType(value="ovrRecti[ovrEye_Count]") OVRRecti.Buffer value) {
            OVRLayerEyeFovMultires.nViewport(this.address(), value);
            return this;
        }

        public Buffer Viewport(int index, @NativeType(value="ovrRecti") OVRRecti value) {
            OVRLayerEyeFovMultires.nViewport(this.address(), index, value);
            return this;
        }

        public Buffer Viewport(Consumer<OVRRecti.Buffer> consumer) {
            consumer.accept(this.Viewport());
            return this;
        }

        public Buffer Viewport(int index, Consumer<OVRRecti> consumer) {
            consumer.accept(this.Viewport(index));
            return this;
        }

        public Buffer Fov(@NativeType(value="ovrFovPort[ovrEye_Count]") OVRFovPort.Buffer value) {
            OVRLayerEyeFovMultires.nFov(this.address(), value);
            return this;
        }

        public Buffer Fov(int index, @NativeType(value="ovrFovPort") OVRFovPort value) {
            OVRLayerEyeFovMultires.nFov(this.address(), index, value);
            return this;
        }

        public Buffer Fov(Consumer<OVRFovPort.Buffer> consumer) {
            consumer.accept(this.Fov());
            return this;
        }

        public Buffer Fov(int index, Consumer<OVRFovPort> consumer) {
            consumer.accept(this.Fov(index));
            return this;
        }

        public Buffer RenderPose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
            OVRLayerEyeFovMultires.nRenderPose(this.address(), value);
            return this;
        }

        public Buffer RenderPose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
            OVRLayerEyeFovMultires.nRenderPose(this.address(), index, value);
            return this;
        }

        public Buffer RenderPose(Consumer<OVRPosef.Buffer> consumer) {
            consumer.accept(this.RenderPose());
            return this;
        }

        public Buffer RenderPose(int index, Consumer<OVRPosef> consumer) {
            consumer.accept(this.RenderPose(index));
            return this;
        }

        public Buffer SensorSampleTime(double value) {
            OVRLayerEyeFovMultires.nSensorSampleTime(this.address(), value);
            return this;
        }

        public Buffer TextureLayout(@NativeType(value="ovrTextureLayout") int value) {
            OVRLayerEyeFovMultires.nTextureLayout(this.address(), value);
            return this;
        }

        public Buffer TextureLayoutDesc(@NativeType(value="ovrTextureLayoutDesc_Union") OVRTextureLayoutDescUnion value) {
            OVRLayerEyeFovMultires.nTextureLayoutDesc(this.address(), value);
            return this;
        }

        public Buffer TextureLayoutDesc(Consumer<OVRTextureLayoutDescUnion> consumer) {
            consumer.accept(this.TextureLayoutDesc());
            return this;
        }
    }
}

