/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrLayerHeader")
public class OVRLayerHeader
extends Struct<OVRLayerHeader>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int FLAGS;

    protected OVRLayerHeader(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVRLayerHeader create(long address, @Nullable ByteBuffer container) {
        return new OVRLayerHeader(address, container);
    }

    public OVRLayerHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVRLayerHeader.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerType")
    public int Type() {
        return OVRLayerHeader.nType(this.address());
    }

    @NativeType(value="unsigned int")
    public int Flags() {
        return OVRLayerHeader.nFlags(this.address());
    }

    public OVRLayerHeader Type(@NativeType(value="ovrLayerType") int value) {
        OVRLayerHeader.nType(this.address(), value);
        return this;
    }

    public OVRLayerHeader Flags(@NativeType(value="unsigned int") int value) {
        OVRLayerHeader.nFlags(this.address(), value);
        return this;
    }

    public OVRLayerHeader set(int Type2, int Flags2) {
        this.Type(Type2);
        this.Flags(Flags2);
        return this;
    }

    public OVRLayerHeader set(OVRLayerHeader src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRLayerHeader malloc() {
        return new OVRLayerHeader(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVRLayerHeader calloc() {
        return new OVRLayerHeader(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVRLayerHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVRLayerHeader(MemoryUtil.memAddress(container), container);
    }

    public static OVRLayerHeader create(long address) {
        return new OVRLayerHeader(address, null);
    }

    public static @Nullable OVRLayerHeader createSafe(long address) {
        return address == 0L ? null : new OVRLayerHeader(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OVRLayerHeader.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRLayerHeader.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRLayerHeader mallocStack() {
        return OVRLayerHeader.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerHeader callocStack() {
        return OVRLayerHeader.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerHeader mallocStack(MemoryStack stack) {
        return OVRLayerHeader.malloc(stack);
    }

    @Deprecated
    public static OVRLayerHeader callocStack(MemoryStack stack) {
        return OVRLayerHeader.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRLayerHeader.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRLayerHeader.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerHeader.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerHeader.calloc(capacity, stack);
    }

    public static OVRLayerHeader malloc(MemoryStack stack) {
        return new OVRLayerHeader(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRLayerHeader calloc(MemoryStack stack) {
        return new OVRLayerHeader(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static void nType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = OVRLayerHeader.__struct(DEFAULT_PACK_ALIGNMENT, POINTER_SIZE, OVRLayerHeader.__member(4), OVRLayerHeader.__member(4), OVRLayerHeader.__padding(128, true));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerHeader, Buffer>
    implements NativeResource {
        private static final OVRLayerHeader ELEMENT_FACTORY = OVRLayerHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OVRLayerHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrLayerType")
        public int Type() {
            return OVRLayerHeader.nType(this.address());
        }

        @NativeType(value="unsigned int")
        public int Flags() {
            return OVRLayerHeader.nFlags(this.address());
        }

        public Buffer Type(@NativeType(value="ovrLayerType") int value) {
            OVRLayerHeader.nType(this.address(), value);
            return this;
        }

        public Buffer Flags(@NativeType(value="unsigned int") int value) {
            OVRLayerHeader.nFlags(this.address(), value);
            return this;
        }
    }
}

