/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrSizei")
public class OVRSizei
extends Struct<OVRSizei>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int W;
    public static final int H;

    protected OVRSizei(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVRSizei create(long address, @Nullable ByteBuffer container) {
        return new OVRSizei(address, container);
    }

    public OVRSizei(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVRSizei.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int w() {
        return OVRSizei.nw(this.address());
    }

    public int h() {
        return OVRSizei.nh(this.address());
    }

    public OVRSizei w(int value) {
        OVRSizei.nw(this.address(), value);
        return this;
    }

    public OVRSizei h(int value) {
        OVRSizei.nh(this.address(), value);
        return this;
    }

    public OVRSizei set(int w, int h) {
        this.w(w);
        this.h(h);
        return this;
    }

    public OVRSizei set(OVRSizei src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRSizei malloc() {
        return new OVRSizei(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVRSizei calloc() {
        return new OVRSizei(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVRSizei create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVRSizei(MemoryUtil.memAddress(container), container);
    }

    public static OVRSizei create(long address) {
        return new OVRSizei(address, null);
    }

    public static @Nullable OVRSizei createSafe(long address) {
        return address == 0L ? null : new OVRSizei(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OVRSizei.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRSizei.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRSizei mallocStack() {
        return OVRSizei.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRSizei callocStack() {
        return OVRSizei.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRSizei mallocStack(MemoryStack stack) {
        return OVRSizei.malloc(stack);
    }

    @Deprecated
    public static OVRSizei callocStack(MemoryStack stack) {
        return OVRSizei.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRSizei.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRSizei.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRSizei.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRSizei.calloc(capacity, stack);
    }

    public static OVRSizei malloc(MemoryStack stack) {
        return new OVRSizei(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRSizei calloc(MemoryStack stack) {
        return new OVRSizei(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nw(long struct) {
        return MemoryUtil.memGetInt(struct + (long)W);
    }

    public static int nh(long struct) {
        return MemoryUtil.memGetInt(struct + (long)H);
    }

    public static void nw(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)W, value);
    }

    public static void nh(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)H, value);
    }

    static {
        Struct.Layout layout = OVRSizei.__struct(OVRSizei.__member(4), OVRSizei.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        W = layout.offsetof(0);
        H = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRSizei, Buffer>
    implements NativeResource {
        private static final OVRSizei ELEMENT_FACTORY = OVRSizei.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OVRSizei getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int w() {
            return OVRSizei.nw(this.address());
        }

        public int h() {
            return OVRSizei.nh(this.address());
        }

        public Buffer w(int value) {
            OVRSizei.nw(this.address(), value);
            return this;
        }

        public Buffer h(int value) {
            OVRSizei.nh(this.address(), value);
            return this;
        }
    }
}

