/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrTouchHapticsDesc")
public class OVRTouchHapticsDesc
extends Struct<OVRTouchHapticsDesc>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLERATEHZ;
    public static final int SAMPLESIZEINBYTES;
    public static final int QUEUEMINSIZETOAVOIDSTARVATION;
    public static final int SUBMITMINSAMPLES;
    public static final int SUBMITMAXSAMPLES;
    public static final int SUBMITOPTIMALSAMPLES;

    protected OVRTouchHapticsDesc(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OVRTouchHapticsDesc create(long address, @Nullable ByteBuffer container) {
        return new OVRTouchHapticsDesc(address, container);
    }

    public OVRTouchHapticsDesc(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OVRTouchHapticsDesc.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int SampleRateHz() {
        return OVRTouchHapticsDesc.nSampleRateHz(this.address());
    }

    public int SampleSizeInBytes() {
        return OVRTouchHapticsDesc.nSampleSizeInBytes(this.address());
    }

    public int QueueMinSizeToAvoidStarvation() {
        return OVRTouchHapticsDesc.nQueueMinSizeToAvoidStarvation(this.address());
    }

    public int SubmitMinSamples() {
        return OVRTouchHapticsDesc.nSubmitMinSamples(this.address());
    }

    public int SubmitMaxSamples() {
        return OVRTouchHapticsDesc.nSubmitMaxSamples(this.address());
    }

    public int SubmitOptimalSamples() {
        return OVRTouchHapticsDesc.nSubmitOptimalSamples(this.address());
    }

    public static OVRTouchHapticsDesc malloc() {
        return new OVRTouchHapticsDesc(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OVRTouchHapticsDesc calloc() {
        return new OVRTouchHapticsDesc(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OVRTouchHapticsDesc create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OVRTouchHapticsDesc(MemoryUtil.memAddress(container), container);
    }

    public static OVRTouchHapticsDesc create(long address) {
        return new OVRTouchHapticsDesc(address, null);
    }

    public static @Nullable OVRTouchHapticsDesc createSafe(long address) {
        return address == 0L ? null : new OVRTouchHapticsDesc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OVRTouchHapticsDesc.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRTouchHapticsDesc.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRTouchHapticsDesc mallocStack() {
        return OVRTouchHapticsDesc.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRTouchHapticsDesc callocStack() {
        return OVRTouchHapticsDesc.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRTouchHapticsDesc mallocStack(MemoryStack stack) {
        return OVRTouchHapticsDesc.malloc(stack);
    }

    @Deprecated
    public static OVRTouchHapticsDesc callocStack(MemoryStack stack) {
        return OVRTouchHapticsDesc.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRTouchHapticsDesc.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRTouchHapticsDesc.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRTouchHapticsDesc.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRTouchHapticsDesc.calloc(capacity, stack);
    }

    public static OVRTouchHapticsDesc malloc(MemoryStack stack) {
        return new OVRTouchHapticsDesc(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRTouchHapticsDesc calloc(MemoryStack stack) {
        return new OVRTouchHapticsDesc(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nSampleRateHz(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLERATEHZ);
    }

    public static int nSampleSizeInBytes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLESIZEINBYTES);
    }

    public static int nQueueMinSizeToAvoidStarvation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUEUEMINSIZETOAVOIDSTARVATION);
    }

    public static int nSubmitMinSamples(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBMITMINSAMPLES);
    }

    public static int nSubmitMaxSamples(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBMITMAXSAMPLES);
    }

    public static int nSubmitOptimalSamples(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBMITOPTIMALSAMPLES);
    }

    static {
        Struct.Layout layout = OVRTouchHapticsDesc.__struct(DEFAULT_PACK_ALIGNMENT, POINTER_SIZE, OVRTouchHapticsDesc.__member(4), OVRTouchHapticsDesc.__member(4), OVRTouchHapticsDesc.__member(4), OVRTouchHapticsDesc.__member(4), OVRTouchHapticsDesc.__member(4), OVRTouchHapticsDesc.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLERATEHZ = layout.offsetof(0);
        SAMPLESIZEINBYTES = layout.offsetof(1);
        QUEUEMINSIZETOAVOIDSTARVATION = layout.offsetof(2);
        SUBMITMINSAMPLES = layout.offsetof(3);
        SUBMITMAXSAMPLES = layout.offsetof(4);
        SUBMITOPTIMALSAMPLES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<OVRTouchHapticsDesc, Buffer>
    implements NativeResource {
        private static final OVRTouchHapticsDesc ELEMENT_FACTORY = OVRTouchHapticsDesc.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OVRTouchHapticsDesc getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int SampleRateHz() {
            return OVRTouchHapticsDesc.nSampleRateHz(this.address());
        }

        public int SampleSizeInBytes() {
            return OVRTouchHapticsDesc.nSampleSizeInBytes(this.address());
        }

        public int QueueMinSizeToAvoidStarvation() {
            return OVRTouchHapticsDesc.nQueueMinSizeToAvoidStarvation(this.address());
        }

        public int SubmitMinSamples() {
            return OVRTouchHapticsDesc.nSubmitMinSamples(this.address());
        }

        public int SubmitMaxSamples() {
            return OVRTouchHapticsDesc.nSubmitMaxSamples(this.address());
        }

        public int SubmitOptimalSamples() {
            return OVRTouchHapticsDesc.nSubmitOptimalSamples(this.address());
        }
    }
}

