/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.rpmalloc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.rpmalloc.RPErrorCallback;
import org.lwjgl.system.rpmalloc.RPErrorCallbackI;
import org.lwjgl.system.rpmalloc.RPMapFailCallback;
import org.lwjgl.system.rpmalloc.RPMapFailCallbackI;
import org.lwjgl.system.rpmalloc.RPMemoryMapCallback;
import org.lwjgl.system.rpmalloc.RPMemoryMapCallbackI;
import org.lwjgl.system.rpmalloc.RPMemoryUnmapCallback;
import org.lwjgl.system.rpmalloc.RPMemoryUnmapCallbackI;

@NativeType(value="struct rpmalloc_config_t")
public class RPMallocConfig
extends Struct<RPMallocConfig>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MEMORY_MAP;
    public static final int MEMORY_UNMAP;
    public static final int ERROR_CALLBACK;
    public static final int MAP_FAIL_CALLBACK;
    public static final int PAGE_SIZE;
    public static final int SPAN_SIZE;
    public static final int SPAN_MAP_COUNT;
    public static final int ENABLE_HUGE_PAGES;
    public static final int PAGE_NAME;
    public static final int HUGE_PAGE_NAME;

    protected RPMallocConfig(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected RPMallocConfig create(long address, @Nullable ByteBuffer container) {
        return new RPMallocConfig(address, container);
    }

    public RPMallocConfig(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), RPMallocConfig.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void * (*) (size_t, size_t *)")
    public @Nullable RPMemoryMapCallback memory_map() {
        return RPMallocConfig.nmemory_map(this.address());
    }

    @NativeType(value="void (*) (void *, size_t, size_t, int)")
    public @Nullable RPMemoryUnmapCallback memory_unmap() {
        return RPMallocConfig.nmemory_unmap(this.address());
    }

    @NativeType(value="void (*) (char const *)")
    public @Nullable RPErrorCallback error_callback() {
        return RPMallocConfig.nerror_callback(this.address());
    }

    @NativeType(value="int (*) (size_t)")
    public @Nullable RPMapFailCallback map_fail_callback() {
        return RPMallocConfig.nmap_fail_callback(this.address());
    }

    @NativeType(value="size_t")
    public long page_size() {
        return RPMallocConfig.npage_size(this.address());
    }

    @NativeType(value="size_t")
    public long span_size() {
        return RPMallocConfig.nspan_size(this.address());
    }

    @NativeType(value="size_t")
    public long span_map_count() {
        return RPMallocConfig.nspan_map_count(this.address());
    }

    @NativeType(value="int")
    public boolean enable_huge_pages() {
        return RPMallocConfig.nenable_huge_pages(this.address()) != 0;
    }

    @NativeType(value="char const *")
    public @Nullable ByteBuffer page_name() {
        return RPMallocConfig.npage_name(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable String page_nameString() {
        return RPMallocConfig.npage_nameString(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable ByteBuffer huge_page_name() {
        return RPMallocConfig.nhuge_page_name(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable String huge_page_nameString() {
        return RPMallocConfig.nhuge_page_nameString(this.address());
    }

    public RPMallocConfig memory_map(@NativeType(value="void * (*) (size_t, size_t *)") @Nullable RPMemoryMapCallbackI value) {
        RPMallocConfig.nmemory_map(this.address(), value);
        return this;
    }

    public RPMallocConfig memory_unmap(@NativeType(value="void (*) (void *, size_t, size_t, int)") @Nullable RPMemoryUnmapCallbackI value) {
        RPMallocConfig.nmemory_unmap(this.address(), value);
        return this;
    }

    public RPMallocConfig error_callback(@NativeType(value="void (*) (char const *)") @Nullable RPErrorCallbackI value) {
        RPMallocConfig.nerror_callback(this.address(), value);
        return this;
    }

    public RPMallocConfig map_fail_callback(@NativeType(value="int (*) (size_t)") @Nullable RPMapFailCallbackI value) {
        RPMallocConfig.nmap_fail_callback(this.address(), value);
        return this;
    }

    public RPMallocConfig page_size(@NativeType(value="size_t") long value) {
        RPMallocConfig.npage_size(this.address(), value);
        return this;
    }

    public RPMallocConfig span_size(@NativeType(value="size_t") long value) {
        RPMallocConfig.nspan_size(this.address(), value);
        return this;
    }

    public RPMallocConfig span_map_count(@NativeType(value="size_t") long value) {
        RPMallocConfig.nspan_map_count(this.address(), value);
        return this;
    }

    public RPMallocConfig enable_huge_pages(@NativeType(value="int") boolean value) {
        RPMallocConfig.nenable_huge_pages(this.address(), value ? 1 : 0);
        return this;
    }

    public RPMallocConfig page_name(@NativeType(value="char const *") @Nullable ByteBuffer value) {
        RPMallocConfig.npage_name(this.address(), value);
        return this;
    }

    public RPMallocConfig huge_page_name(@NativeType(value="char const *") @Nullable ByteBuffer value) {
        RPMallocConfig.nhuge_page_name(this.address(), value);
        return this;
    }

    public RPMallocConfig set(@Nullable RPMemoryMapCallbackI memory_map, @Nullable RPMemoryUnmapCallbackI memory_unmap, @Nullable RPErrorCallbackI error_callback, @Nullable RPMapFailCallbackI map_fail_callback, long page_size, long span_size, long span_map_count, boolean enable_huge_pages, @Nullable ByteBuffer page_name, @Nullable ByteBuffer huge_page_name) {
        this.memory_map(memory_map);
        this.memory_unmap(memory_unmap);
        this.error_callback(error_callback);
        this.map_fail_callback(map_fail_callback);
        this.page_size(page_size);
        this.span_size(span_size);
        this.span_map_count(span_map_count);
        this.enable_huge_pages(enable_huge_pages);
        this.page_name(page_name);
        this.huge_page_name(huge_page_name);
        return this;
    }

    public RPMallocConfig set(RPMallocConfig src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static RPMallocConfig malloc() {
        return new RPMallocConfig(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static RPMallocConfig calloc() {
        return new RPMallocConfig(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static RPMallocConfig create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new RPMallocConfig(MemoryUtil.memAddress(container), container);
    }

    public static RPMallocConfig create(long address) {
        return new RPMallocConfig(address, null);
    }

    public static @Nullable RPMallocConfig createSafe(long address) {
        return address == 0L ? null : new RPMallocConfig(address, null);
    }

    @Deprecated
    public static RPMallocConfig mallocStack() {
        return RPMallocConfig.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static RPMallocConfig callocStack() {
        return RPMallocConfig.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static RPMallocConfig mallocStack(MemoryStack stack) {
        return RPMallocConfig.malloc(stack);
    }

    @Deprecated
    public static RPMallocConfig callocStack(MemoryStack stack) {
        return RPMallocConfig.calloc(stack);
    }

    public static RPMallocConfig malloc(MemoryStack stack) {
        return new RPMallocConfig(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static RPMallocConfig calloc(MemoryStack stack) {
        return new RPMallocConfig(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static @Nullable RPMemoryMapCallback nmemory_map(long struct) {
        return RPMemoryMapCallback.createSafe(MemoryUtil.memGetAddress(struct + (long)MEMORY_MAP));
    }

    public static @Nullable RPMemoryUnmapCallback nmemory_unmap(long struct) {
        return RPMemoryUnmapCallback.createSafe(MemoryUtil.memGetAddress(struct + (long)MEMORY_UNMAP));
    }

    public static @Nullable RPErrorCallback nerror_callback(long struct) {
        return RPErrorCallback.createSafe(MemoryUtil.memGetAddress(struct + (long)ERROR_CALLBACK));
    }

    public static @Nullable RPMapFailCallback nmap_fail_callback(long struct) {
        return RPMapFailCallback.createSafe(MemoryUtil.memGetAddress(struct + (long)MAP_FAIL_CALLBACK));
    }

    public static long npage_size(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PAGE_SIZE);
    }

    public static long nspan_size(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPAN_SIZE);
    }

    public static long nspan_map_count(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPAN_MAP_COUNT);
    }

    public static int nenable_huge_pages(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ENABLE_HUGE_PAGES);
    }

    public static @Nullable ByteBuffer npage_name(long struct) {
        return MemoryUtil.memByteBufferNT1Safe(MemoryUtil.memGetAddress(struct + (long)PAGE_NAME));
    }

    public static @Nullable String npage_nameString(long struct) {
        return MemoryUtil.memASCIISafe(MemoryUtil.memGetAddress(struct + (long)PAGE_NAME));
    }

    public static @Nullable ByteBuffer nhuge_page_name(long struct) {
        return MemoryUtil.memByteBufferNT1Safe(MemoryUtil.memGetAddress(struct + (long)HUGE_PAGE_NAME));
    }

    public static @Nullable String nhuge_page_nameString(long struct) {
        return MemoryUtil.memASCIISafe(MemoryUtil.memGetAddress(struct + (long)HUGE_PAGE_NAME));
    }

    public static void nmemory_map(long struct, @Nullable RPMemoryMapCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)MEMORY_MAP, MemoryUtil.memAddressSafe(value));
    }

    public static void nmemory_unmap(long struct, @Nullable RPMemoryUnmapCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)MEMORY_UNMAP, MemoryUtil.memAddressSafe(value));
    }

    public static void nerror_callback(long struct, @Nullable RPErrorCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)ERROR_CALLBACK, MemoryUtil.memAddressSafe(value));
    }

    public static void nmap_fail_callback(long struct, @Nullable RPMapFailCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)MAP_FAIL_CALLBACK, MemoryUtil.memAddressSafe(value));
    }

    public static void npage_size(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PAGE_SIZE, value);
    }

    public static void nspan_size(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SPAN_SIZE, value);
    }

    public static void nspan_map_count(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SPAN_MAP_COUNT, value);
    }

    public static void nenable_huge_pages(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ENABLE_HUGE_PAGES, value);
    }

    public static void npage_name(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)PAGE_NAME, MemoryUtil.memAddressSafe(value));
    }

    public static void nhuge_page_name(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)HUGE_PAGE_NAME, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = RPMallocConfig.__struct(RPMallocConfig.__member(POINTER_SIZE), RPMallocConfig.__member(POINTER_SIZE), RPMallocConfig.__member(POINTER_SIZE), RPMallocConfig.__member(POINTER_SIZE), RPMallocConfig.__member(POINTER_SIZE), RPMallocConfig.__member(POINTER_SIZE), RPMallocConfig.__member(POINTER_SIZE), RPMallocConfig.__member(4), RPMallocConfig.__member(POINTER_SIZE), RPMallocConfig.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MEMORY_MAP = layout.offsetof(0);
        MEMORY_UNMAP = layout.offsetof(1);
        ERROR_CALLBACK = layout.offsetof(2);
        MAP_FAIL_CALLBACK = layout.offsetof(3);
        PAGE_SIZE = layout.offsetof(4);
        SPAN_SIZE = layout.offsetof(5);
        SPAN_MAP_COUNT = layout.offsetof(6);
        ENABLE_HUGE_PAGES = layout.offsetof(7);
        PAGE_NAME = layout.offsetof(8);
        HUGE_PAGE_NAME = layout.offsetof(9);
    }
}

