/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.rpmalloc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct rpmalloc_global_statistics_t")
public class RPmallocGlobalStatistics
extends Struct<RPmallocGlobalStatistics>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAPPED;
    public static final int MAPPED_PEAK;
    public static final int CACHED;
    public static final int HUGE_ALLOC;
    public static final int HUGE_ALLOC_PEAK;
    public static final int MAPPED_TOTAL;
    public static final int UNMAPPED_TOTAL;

    protected RPmallocGlobalStatistics(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected RPmallocGlobalStatistics create(long address, @Nullable ByteBuffer container) {
        return new RPmallocGlobalStatistics(address, container);
    }

    public RPmallocGlobalStatistics(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), RPmallocGlobalStatistics.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long mapped() {
        return RPmallocGlobalStatistics.nmapped(this.address());
    }

    @NativeType(value="size_t")
    public long mapped_peak() {
        return RPmallocGlobalStatistics.nmapped_peak(this.address());
    }

    @NativeType(value="size_t")
    public long cached() {
        return RPmallocGlobalStatistics.ncached(this.address());
    }

    @NativeType(value="size_t")
    public long huge_alloc() {
        return RPmallocGlobalStatistics.nhuge_alloc(this.address());
    }

    @NativeType(value="size_t")
    public long huge_alloc_peak() {
        return RPmallocGlobalStatistics.nhuge_alloc_peak(this.address());
    }

    @NativeType(value="size_t")
    public long mapped_total() {
        return RPmallocGlobalStatistics.nmapped_total(this.address());
    }

    @NativeType(value="size_t")
    public long unmapped_total() {
        return RPmallocGlobalStatistics.nunmapped_total(this.address());
    }

    public static RPmallocGlobalStatistics malloc() {
        return new RPmallocGlobalStatistics(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static RPmallocGlobalStatistics calloc() {
        return new RPmallocGlobalStatistics(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static RPmallocGlobalStatistics create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new RPmallocGlobalStatistics(MemoryUtil.memAddress(container), container);
    }

    public static RPmallocGlobalStatistics create(long address) {
        return new RPmallocGlobalStatistics(address, null);
    }

    public static @Nullable RPmallocGlobalStatistics createSafe(long address) {
        return address == 0L ? null : new RPmallocGlobalStatistics(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(RPmallocGlobalStatistics.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = RPmallocGlobalStatistics.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static RPmallocGlobalStatistics mallocStack() {
        return RPmallocGlobalStatistics.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static RPmallocGlobalStatistics callocStack() {
        return RPmallocGlobalStatistics.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static RPmallocGlobalStatistics mallocStack(MemoryStack stack) {
        return RPmallocGlobalStatistics.malloc(stack);
    }

    @Deprecated
    public static RPmallocGlobalStatistics callocStack(MemoryStack stack) {
        return RPmallocGlobalStatistics.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return RPmallocGlobalStatistics.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return RPmallocGlobalStatistics.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return RPmallocGlobalStatistics.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return RPmallocGlobalStatistics.calloc(capacity, stack);
    }

    public static RPmallocGlobalStatistics malloc(MemoryStack stack) {
        return new RPmallocGlobalStatistics(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static RPmallocGlobalStatistics calloc(MemoryStack stack) {
        return new RPmallocGlobalStatistics(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nmapped(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MAPPED);
    }

    public static long nmapped_peak(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MAPPED_PEAK);
    }

    public static long ncached(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CACHED);
    }

    public static long nhuge_alloc(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HUGE_ALLOC);
    }

    public static long nhuge_alloc_peak(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HUGE_ALLOC_PEAK);
    }

    public static long nmapped_total(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MAPPED_TOTAL);
    }

    public static long nunmapped_total(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)UNMAPPED_TOTAL);
    }

    static {
        Struct.Layout layout = RPmallocGlobalStatistics.__struct(RPmallocGlobalStatistics.__member(POINTER_SIZE), RPmallocGlobalStatistics.__member(POINTER_SIZE), RPmallocGlobalStatistics.__member(POINTER_SIZE), RPmallocGlobalStatistics.__member(POINTER_SIZE), RPmallocGlobalStatistics.__member(POINTER_SIZE), RPmallocGlobalStatistics.__member(POINTER_SIZE), RPmallocGlobalStatistics.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAPPED = layout.offsetof(0);
        MAPPED_PEAK = layout.offsetof(1);
        CACHED = layout.offsetof(2);
        HUGE_ALLOC = layout.offsetof(3);
        HUGE_ALLOC_PEAK = layout.offsetof(4);
        MAPPED_TOTAL = layout.offsetof(5);
        UNMAPPED_TOTAL = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<RPmallocGlobalStatistics, Buffer>
    implements NativeResource {
        private static final RPmallocGlobalStatistics ELEMENT_FACTORY = RPmallocGlobalStatistics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected RPmallocGlobalStatistics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long mapped() {
            return RPmallocGlobalStatistics.nmapped(this.address());
        }

        @NativeType(value="size_t")
        public long mapped_peak() {
            return RPmallocGlobalStatistics.nmapped_peak(this.address());
        }

        @NativeType(value="size_t")
        public long cached() {
            return RPmallocGlobalStatistics.ncached(this.address());
        }

        @NativeType(value="size_t")
        public long huge_alloc() {
            return RPmallocGlobalStatistics.nhuge_alloc(this.address());
        }

        @NativeType(value="size_t")
        public long huge_alloc_peak() {
            return RPmallocGlobalStatistics.nhuge_alloc_peak(this.address());
        }

        @NativeType(value="size_t")
        public long mapped_total() {
            return RPmallocGlobalStatistics.nmapped_total(this.address());
        }

        @NativeType(value="size_t")
        public long unmapped_total() {
            return RPmallocGlobalStatistics.nunmapped_total(this.address());
        }
    }
}

