/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.hwloc;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct hwloc_distances_s")
public class hwloc_distances_s
extends Struct<hwloc_distances_s>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NBOBJS;
    public static final int OBJS;
    public static final int KIND;
    public static final int VALUES;

    protected hwloc_distances_s(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected hwloc_distances_s create(long address, @Nullable ByteBuffer container) {
        return new hwloc_distances_s(address, container);
    }

    public hwloc_distances_s(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), hwloc_distances_s.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int nbobjs() {
        return hwloc_distances_s.nnbobjs(this.address());
    }

    @NativeType(value="hwloc_obj_t *")
    public PointerBuffer objs() {
        return hwloc_distances_s.nobjs(this.address());
    }

    @NativeType(value="unsigned long")
    public long kind() {
        return hwloc_distances_s.nkind(this.address());
    }

    @NativeType(value="hwloc_uint64_t *")
    public LongBuffer values() {
        return hwloc_distances_s.nvalues(this.address());
    }

    public static hwloc_distances_s malloc() {
        return new hwloc_distances_s(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static hwloc_distances_s calloc() {
        return new hwloc_distances_s(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static hwloc_distances_s create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new hwloc_distances_s(MemoryUtil.memAddress(container), container);
    }

    public static hwloc_distances_s create(long address) {
        return new hwloc_distances_s(address, null);
    }

    public static @Nullable hwloc_distances_s createSafe(long address) {
        return address == 0L ? null : new hwloc_distances_s(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(hwloc_distances_s.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = hwloc_distances_s.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static hwloc_distances_s malloc(MemoryStack stack) {
        return new hwloc_distances_s(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static hwloc_distances_s calloc(MemoryStack stack) {
        return new hwloc_distances_s(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nnbobjs(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NBOBJS);
    }

    public static PointerBuffer nobjs(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)OBJS), hwloc_distances_s.nnbobjs(struct));
    }

    public static long nkind(long struct) {
        return MemoryUtil.memGetCLong(struct + (long)KIND);
    }

    public static LongBuffer nvalues(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)VALUES), hwloc_distances_s.nnbobjs(struct) * hwloc_distances_s.nnbobjs(struct));
    }

    static {
        Struct.Layout layout = hwloc_distances_s.__struct(hwloc_distances_s.__member(4), hwloc_distances_s.__member(POINTER_SIZE), hwloc_distances_s.__member(CLONG_SIZE), hwloc_distances_s.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NBOBJS = layout.offsetof(0);
        OBJS = layout.offsetof(1);
        KIND = layout.offsetof(2);
        VALUES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<hwloc_distances_s, Buffer>
    implements NativeResource {
        private static final hwloc_distances_s ELEMENT_FACTORY = hwloc_distances_s.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected hwloc_distances_s getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int nbobjs() {
            return hwloc_distances_s.nnbobjs(this.address());
        }

        @NativeType(value="hwloc_obj_t *")
        public PointerBuffer objs() {
            return hwloc_distances_s.nobjs(this.address());
        }

        @NativeType(value="unsigned long")
        public long kind() {
            return hwloc_distances_s.nkind(this.address());
        }

        @NativeType(value="hwloc_uint64_t *")
        public LongBuffer values() {
            return hwloc_distances_s.nvalues(this.address());
        }
    }
}

