/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.hwloc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct hwloc_info_s")
public class hwloc_info_s
extends Struct<hwloc_info_s>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int VALUE;

    protected hwloc_info_s(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected hwloc_info_s create(long address, @Nullable ByteBuffer container) {
        return new hwloc_info_s(address, container);
    }

    public hwloc_info_s(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), hwloc_info_s.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char *")
    public ByteBuffer name() {
        return hwloc_info_s.nname(this.address());
    }

    @NativeType(value="char *")
    public String nameString() {
        return hwloc_info_s.nnameString(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer value() {
        return hwloc_info_s.nvalue(this.address());
    }

    @NativeType(value="char *")
    public String valueString() {
        return hwloc_info_s.nvalueString(this.address());
    }

    public static hwloc_info_s malloc() {
        return new hwloc_info_s(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static hwloc_info_s calloc() {
        return new hwloc_info_s(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static hwloc_info_s create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new hwloc_info_s(MemoryUtil.memAddress(container), container);
    }

    public static hwloc_info_s create(long address) {
        return new hwloc_info_s(address, null);
    }

    public static @Nullable hwloc_info_s createSafe(long address) {
        return address == 0L ? null : new hwloc_info_s(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(hwloc_info_s.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = hwloc_info_s.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static hwloc_info_s malloc(MemoryStack stack) {
        return new hwloc_info_s(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static hwloc_info_s calloc(MemoryStack stack) {
        return new hwloc_info_s(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memASCII(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static ByteBuffer nvalue(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)VALUE));
    }

    public static String nvalueString(long struct) {
        return MemoryUtil.memASCII(MemoryUtil.memGetAddress(struct + (long)VALUE));
    }

    static {
        Struct.Layout layout = hwloc_info_s.__struct(hwloc_info_s.__member(POINTER_SIZE), hwloc_info_s.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        VALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<hwloc_info_s, Buffer>
    implements NativeResource {
        private static final hwloc_info_s ELEMENT_FACTORY = hwloc_info_s.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected hwloc_info_s getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char *")
        public ByteBuffer name() {
            return hwloc_info_s.nname(this.address());
        }

        @NativeType(value="char *")
        public String nameString() {
            return hwloc_info_s.nnameString(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer value() {
            return hwloc_info_s.nvalue(this.address());
        }

        @NativeType(value="char *")
        public String valueString() {
            return hwloc_info_s.nvalueString(this.address());
        }
    }
}

