/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.hwloc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.hwloc.hwloc_obj;

public class hwloc_location_u
extends Struct<hwloc_location_u> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CPUSET;
    public static final int OBJECT;

    protected hwloc_location_u(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected hwloc_location_u create(long address, @Nullable ByteBuffer container) {
        return new hwloc_location_u(address, container);
    }

    public hwloc_location_u(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), hwloc_location_u.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="hwloc_cpuset_t")
    public long cpuset() {
        return hwloc_location_u.ncpuset(this.address());
    }

    @NativeType(value="hwloc_obj_t")
    public hwloc_obj object() {
        return hwloc_location_u.nobject(this.address());
    }

    public static hwloc_location_u create(long address) {
        return new hwloc_location_u(address, null);
    }

    public static @Nullable hwloc_location_u createSafe(long address) {
        return address == 0L ? null : new hwloc_location_u(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static long ncpuset(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CPUSET);
    }

    public static hwloc_obj nobject(long struct) {
        return hwloc_obj.create(MemoryUtil.memGetAddress(struct + (long)OBJECT));
    }

    static {
        Struct.Layout layout = hwloc_location_u.__union(hwloc_location_u.__member(POINTER_SIZE), hwloc_location_u.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CPUSET = layout.offsetof(0);
        OBJECT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<hwloc_location_u, Buffer> {
        private static final hwloc_location_u ELEMENT_FACTORY = hwloc_location_u.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected hwloc_location_u getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="hwloc_cpuset_t")
        public long cpuset() {
            return hwloc_location_u.ncpuset(this.address());
        }

        @NativeType(value="hwloc_obj_t")
        public hwloc_obj object() {
            return hwloc_location_u.nobject(this.address());
        }
    }
}

