/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.ktx;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.ktx.ktxVulkanFunctions;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkPhysicalDeviceMemoryProperties;
import org.lwjgl.vulkan.VkQueue;

public class ktxVulkanDeviceInfo
extends Struct<ktxVulkanDeviceInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INSTANCE;
    public static final int PHYSICALDEVICE;
    public static final int DEVICE;
    public static final int QUEUE;
    public static final int CMDBUFFER;
    public static final int CMDPOOL;
    public static final int PALLOCATOR;
    public static final int DEVICEMEMORYPROPERTIES;
    public static final int VKFUNCS;

    protected ktxVulkanDeviceInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected ktxVulkanDeviceInfo create(long address, @Nullable ByteBuffer container) {
        return new ktxVulkanDeviceInfo(address, container);
    }

    public ktxVulkanDeviceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ktxVulkanDeviceInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkInstance")
    public long instance() {
        return ktxVulkanDeviceInfo.ninstance(this.address());
    }

    @NativeType(value="VkPhysicalDevice")
    public long physicalDevice() {
        return ktxVulkanDeviceInfo.nphysicalDevice(this.address());
    }

    @NativeType(value="VkDevice")
    public long device() {
        return ktxVulkanDeviceInfo.ndevice(this.address());
    }

    @NativeType(value="VkQueue")
    public long queue() {
        return ktxVulkanDeviceInfo.nqueue(this.address());
    }

    @NativeType(value="VkCommandBuffer")
    public long cmdBuffer() {
        return ktxVulkanDeviceInfo.ncmdBuffer(this.address());
    }

    @NativeType(value="VkCommandPool")
    public long cmdPool() {
        return ktxVulkanDeviceInfo.ncmdPool(this.address());
    }

    @NativeType(value="VkAllocationCallbacks const *")
    public @Nullable VkAllocationCallbacks pAllocator() {
        return ktxVulkanDeviceInfo.npAllocator(this.address());
    }

    public VkPhysicalDeviceMemoryProperties deviceMemoryProperties() {
        return ktxVulkanDeviceInfo.ndeviceMemoryProperties(this.address());
    }

    public ktxVulkanFunctions vkFuncs() {
        return ktxVulkanDeviceInfo.nvkFuncs(this.address());
    }

    public ktxVulkanDeviceInfo instance(VkInstance value) {
        ktxVulkanDeviceInfo.ninstance(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo physicalDevice(VkPhysicalDevice value) {
        ktxVulkanDeviceInfo.nphysicalDevice(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo device(VkDevice value) {
        ktxVulkanDeviceInfo.ndevice(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo queue(VkQueue value) {
        ktxVulkanDeviceInfo.nqueue(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo cmdBuffer(VkCommandBuffer value) {
        ktxVulkanDeviceInfo.ncmdBuffer(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo cmdPool(@NativeType(value="VkCommandPool") long value) {
        ktxVulkanDeviceInfo.ncmdPool(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo pAllocator(@NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks value) {
        ktxVulkanDeviceInfo.npAllocator(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo deviceMemoryProperties(VkPhysicalDeviceMemoryProperties value) {
        ktxVulkanDeviceInfo.ndeviceMemoryProperties(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo vkFuncs(ktxVulkanFunctions value) {
        ktxVulkanDeviceInfo.nvkFuncs(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo vkFuncs(Consumer<ktxVulkanFunctions> consumer) {
        consumer.accept(this.vkFuncs());
        return this;
    }

    public ktxVulkanDeviceInfo set(VkInstance instance, VkPhysicalDevice physicalDevice, VkDevice device, VkQueue queue, VkCommandBuffer cmdBuffer, long cmdPool, @Nullable VkAllocationCallbacks pAllocator, VkPhysicalDeviceMemoryProperties deviceMemoryProperties, ktxVulkanFunctions vkFuncs) {
        this.instance(instance);
        this.physicalDevice(physicalDevice);
        this.device(device);
        this.queue(queue);
        this.cmdBuffer(cmdBuffer);
        this.cmdPool(cmdPool);
        this.pAllocator(pAllocator);
        this.deviceMemoryProperties(deviceMemoryProperties);
        this.vkFuncs(vkFuncs);
        return this;
    }

    public ktxVulkanDeviceInfo set(ktxVulkanDeviceInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ktxVulkanDeviceInfo malloc() {
        return new ktxVulkanDeviceInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static ktxVulkanDeviceInfo calloc() {
        return new ktxVulkanDeviceInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static ktxVulkanDeviceInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new ktxVulkanDeviceInfo(MemoryUtil.memAddress(container), container);
    }

    public static ktxVulkanDeviceInfo create(long address) {
        return new ktxVulkanDeviceInfo(address, null);
    }

    public static @Nullable ktxVulkanDeviceInfo createSafe(long address) {
        return address == 0L ? null : new ktxVulkanDeviceInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(ktxVulkanDeviceInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ktxVulkanDeviceInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static ktxVulkanDeviceInfo malloc(MemoryStack stack) {
        return new ktxVulkanDeviceInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ktxVulkanDeviceInfo calloc(MemoryStack stack) {
        return new ktxVulkanDeviceInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ninstance(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)INSTANCE);
    }

    public static long nphysicalDevice(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PHYSICALDEVICE);
    }

    public static long ndevice(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DEVICE);
    }

    public static long nqueue(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)QUEUE);
    }

    public static long ncmdBuffer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CMDBUFFER);
    }

    public static long ncmdPool(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CMDPOOL);
    }

    public static @Nullable VkAllocationCallbacks npAllocator(long struct) {
        return VkAllocationCallbacks.createSafe(MemoryUtil.memGetAddress(struct + (long)PALLOCATOR));
    }

    public static VkPhysicalDeviceMemoryProperties ndeviceMemoryProperties(long struct) {
        return VkPhysicalDeviceMemoryProperties.create(struct + (long)DEVICEMEMORYPROPERTIES);
    }

    public static ktxVulkanFunctions nvkFuncs(long struct) {
        return ktxVulkanFunctions.create(struct + (long)VKFUNCS);
    }

    public static void ninstance(long struct, VkInstance value) {
        MemoryUtil.memPutAddress(struct + (long)INSTANCE, value.address());
    }

    public static void nphysicalDevice(long struct, VkPhysicalDevice value) {
        MemoryUtil.memPutAddress(struct + (long)PHYSICALDEVICE, value.address());
    }

    public static void ndevice(long struct, VkDevice value) {
        MemoryUtil.memPutAddress(struct + (long)DEVICE, value.address());
    }

    public static void nqueue(long struct, VkQueue value) {
        MemoryUtil.memPutAddress(struct + (long)QUEUE, value.address());
    }

    public static void ncmdBuffer(long struct, VkCommandBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)CMDBUFFER, value.address());
    }

    public static void ncmdPool(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)CMDPOOL, value);
    }

    public static void npAllocator(long struct, @Nullable VkAllocationCallbacks value) {
        MemoryUtil.memPutAddress(struct + (long)PALLOCATOR, MemoryUtil.memAddressSafe(value));
    }

    public static void ndeviceMemoryProperties(long struct, VkPhysicalDeviceMemoryProperties value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DEVICEMEMORYPROPERTIES, VkPhysicalDeviceMemoryProperties.SIZEOF);
    }

    public static void nvkFuncs(long struct, ktxVulkanFunctions value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VKFUNCS, ktxVulkanFunctions.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)INSTANCE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PHYSICALDEVICE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DEVICE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)QUEUE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CMDBUFFER));
        ktxVulkanFunctions.validate(struct + (long)VKFUNCS);
    }

    static {
        Struct.Layout layout = ktxVulkanDeviceInfo.__struct(ktxVulkanDeviceInfo.__member(POINTER_SIZE), ktxVulkanDeviceInfo.__member(POINTER_SIZE), ktxVulkanDeviceInfo.__member(POINTER_SIZE), ktxVulkanDeviceInfo.__member(POINTER_SIZE), ktxVulkanDeviceInfo.__member(POINTER_SIZE), ktxVulkanDeviceInfo.__member(8), ktxVulkanDeviceInfo.__member(POINTER_SIZE), ktxVulkanDeviceInfo.__member(VkPhysicalDeviceMemoryProperties.SIZEOF, VkPhysicalDeviceMemoryProperties.ALIGNOF), ktxVulkanDeviceInfo.__member(ktxVulkanFunctions.SIZEOF, ktxVulkanFunctions.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INSTANCE = layout.offsetof(0);
        PHYSICALDEVICE = layout.offsetof(1);
        DEVICE = layout.offsetof(2);
        QUEUE = layout.offsetof(3);
        CMDBUFFER = layout.offsetof(4);
        CMDPOOL = layout.offsetof(5);
        PALLOCATOR = layout.offsetof(6);
        DEVICEMEMORYPROPERTIES = layout.offsetof(7);
        VKFUNCS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<ktxVulkanDeviceInfo, Buffer>
    implements NativeResource {
        private static final ktxVulkanDeviceInfo ELEMENT_FACTORY = ktxVulkanDeviceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected ktxVulkanDeviceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkInstance")
        public long instance() {
            return ktxVulkanDeviceInfo.ninstance(this.address());
        }

        @NativeType(value="VkPhysicalDevice")
        public long physicalDevice() {
            return ktxVulkanDeviceInfo.nphysicalDevice(this.address());
        }

        @NativeType(value="VkDevice")
        public long device() {
            return ktxVulkanDeviceInfo.ndevice(this.address());
        }

        @NativeType(value="VkQueue")
        public long queue() {
            return ktxVulkanDeviceInfo.nqueue(this.address());
        }

        @NativeType(value="VkCommandBuffer")
        public long cmdBuffer() {
            return ktxVulkanDeviceInfo.ncmdBuffer(this.address());
        }

        @NativeType(value="VkCommandPool")
        public long cmdPool() {
            return ktxVulkanDeviceInfo.ncmdPool(this.address());
        }

        @NativeType(value="VkAllocationCallbacks const *")
        public @Nullable VkAllocationCallbacks pAllocator() {
            return ktxVulkanDeviceInfo.npAllocator(this.address());
        }

        public VkPhysicalDeviceMemoryProperties deviceMemoryProperties() {
            return ktxVulkanDeviceInfo.ndeviceMemoryProperties(this.address());
        }

        public ktxVulkanFunctions vkFuncs() {
            return ktxVulkanDeviceInfo.nvkFuncs(this.address());
        }

        public Buffer instance(VkInstance value) {
            ktxVulkanDeviceInfo.ninstance(this.address(), value);
            return this;
        }

        public Buffer physicalDevice(VkPhysicalDevice value) {
            ktxVulkanDeviceInfo.nphysicalDevice(this.address(), value);
            return this;
        }

        public Buffer device(VkDevice value) {
            ktxVulkanDeviceInfo.ndevice(this.address(), value);
            return this;
        }

        public Buffer queue(VkQueue value) {
            ktxVulkanDeviceInfo.nqueue(this.address(), value);
            return this;
        }

        public Buffer cmdBuffer(VkCommandBuffer value) {
            ktxVulkanDeviceInfo.ncmdBuffer(this.address(), value);
            return this;
        }

        public Buffer cmdPool(@NativeType(value="VkCommandPool") long value) {
            ktxVulkanDeviceInfo.ncmdPool(this.address(), value);
            return this;
        }

        public Buffer pAllocator(@NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks value) {
            ktxVulkanDeviceInfo.npAllocator(this.address(), value);
            return this;
        }

        public Buffer deviceMemoryProperties(VkPhysicalDeviceMemoryProperties value) {
            ktxVulkanDeviceInfo.ndeviceMemoryProperties(this.address(), value);
            return this;
        }

        public Buffer vkFuncs(ktxVulkanFunctions value) {
            ktxVulkanDeviceInfo.nvkFuncs(this.address(), value);
            return this;
        }

        public Buffer vkFuncs(Consumer<ktxVulkanFunctions> consumer) {
            consumer.accept(this.vkFuncs());
            return this;
        }
    }
}

