/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.ktx;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class ktxVulkanTexture
extends Struct<ktxVulkanTexture>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VKDESTROYIMAGE;
    public static final int VKFREEMEMORY;
    public static final int IMAGE;
    public static final int IMAGEFORMAT;
    public static final int IMAGELAYOUT;
    public static final int DEVICEMEMORY;
    public static final int VIEWTYPE;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DEPTH;
    public static final int LEVELCOUNT;
    public static final int LAYERCOUNT;
    public static final int ALLOCATIONID;

    protected ktxVulkanTexture(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected ktxVulkanTexture create(long address, @Nullable ByteBuffer container) {
        return new ktxVulkanTexture(address, container);
    }

    public ktxVulkanTexture(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ktxVulkanTexture.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="PFN_vkDestroyImage")
    public long vkDestroyImage() {
        return ktxVulkanTexture.nvkDestroyImage(this.address());
    }

    @NativeType(value="PFN_vkFreeMemory")
    public long vkFreeMemory() {
        return ktxVulkanTexture.nvkFreeMemory(this.address());
    }

    @NativeType(value="VkImage")
    public long image() {
        return ktxVulkanTexture.nimage(this.address());
    }

    @NativeType(value="VkFormat")
    public int imageFormat() {
        return ktxVulkanTexture.nimageFormat(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int imageLayout() {
        return ktxVulkanTexture.nimageLayout(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long deviceMemory() {
        return ktxVulkanTexture.ndeviceMemory(this.address());
    }

    @NativeType(value="VkImageViewType")
    public int viewType() {
        return ktxVulkanTexture.nviewType(this.address());
    }

    @NativeType(value="uint32_t")
    public int width() {
        return ktxVulkanTexture.nwidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int height() {
        return ktxVulkanTexture.nheight(this.address());
    }

    @NativeType(value="uint32_t")
    public int depth() {
        return ktxVulkanTexture.ndepth(this.address());
    }

    @NativeType(value="uint32_t")
    public int levelCount() {
        return ktxVulkanTexture.nlevelCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int layerCount() {
        return ktxVulkanTexture.nlayerCount(this.address());
    }

    @NativeType(value="uint64_t")
    public long allocationId() {
        return ktxVulkanTexture.nallocationId(this.address());
    }

    public static ktxVulkanTexture malloc() {
        return new ktxVulkanTexture(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static ktxVulkanTexture calloc() {
        return new ktxVulkanTexture(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static ktxVulkanTexture create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new ktxVulkanTexture(MemoryUtil.memAddress(container), container);
    }

    public static ktxVulkanTexture create(long address) {
        return new ktxVulkanTexture(address, null);
    }

    public static @Nullable ktxVulkanTexture createSafe(long address) {
        return address == 0L ? null : new ktxVulkanTexture(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(ktxVulkanTexture.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ktxVulkanTexture.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static ktxVulkanTexture malloc(MemoryStack stack) {
        return new ktxVulkanTexture(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ktxVulkanTexture calloc(MemoryStack stack) {
        return new ktxVulkanTexture(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nvkDestroyImage(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKDESTROYIMAGE);
    }

    public static long nvkFreeMemory(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VKFREEMEMORY);
    }

    public static long nimage(long struct) {
        return MemoryUtil.memGetLong(struct + (long)IMAGE);
    }

    public static int nimageFormat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGEFORMAT);
    }

    public static int nimageLayout(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGELAYOUT);
    }

    public static long ndeviceMemory(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DEVICEMEMORY);
    }

    public static int nviewType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VIEWTYPE);
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEIGHT);
    }

    public static int ndepth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPTH);
    }

    public static int nlevelCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LEVELCOUNT);
    }

    public static int nlayerCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LAYERCOUNT);
    }

    public static long nallocationId(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ALLOCATIONID);
    }

    static {
        Struct.Layout layout = ktxVulkanTexture.__struct(ktxVulkanTexture.__member(POINTER_SIZE), ktxVulkanTexture.__member(POINTER_SIZE), ktxVulkanTexture.__member(8), ktxVulkanTexture.__member(4), ktxVulkanTexture.__member(4), ktxVulkanTexture.__member(8), ktxVulkanTexture.__member(4), ktxVulkanTexture.__member(4), ktxVulkanTexture.__member(4), ktxVulkanTexture.__member(4), ktxVulkanTexture.__member(4), ktxVulkanTexture.__member(4), ktxVulkanTexture.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VKDESTROYIMAGE = layout.offsetof(0);
        VKFREEMEMORY = layout.offsetof(1);
        IMAGE = layout.offsetof(2);
        IMAGEFORMAT = layout.offsetof(3);
        IMAGELAYOUT = layout.offsetof(4);
        DEVICEMEMORY = layout.offsetof(5);
        VIEWTYPE = layout.offsetof(6);
        WIDTH = layout.offsetof(7);
        HEIGHT = layout.offsetof(8);
        DEPTH = layout.offsetof(9);
        LEVELCOUNT = layout.offsetof(10);
        LAYERCOUNT = layout.offsetof(11);
        ALLOCATIONID = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<ktxVulkanTexture, Buffer>
    implements NativeResource {
        private static final ktxVulkanTexture ELEMENT_FACTORY = ktxVulkanTexture.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected ktxVulkanTexture getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="PFN_vkDestroyImage")
        public long vkDestroyImage() {
            return ktxVulkanTexture.nvkDestroyImage(this.address());
        }

        @NativeType(value="PFN_vkFreeMemory")
        public long vkFreeMemory() {
            return ktxVulkanTexture.nvkFreeMemory(this.address());
        }

        @NativeType(value="VkImage")
        public long image() {
            return ktxVulkanTexture.nimage(this.address());
        }

        @NativeType(value="VkFormat")
        public int imageFormat() {
            return ktxVulkanTexture.nimageFormat(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int imageLayout() {
            return ktxVulkanTexture.nimageLayout(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long deviceMemory() {
            return ktxVulkanTexture.ndeviceMemory(this.address());
        }

        @NativeType(value="VkImageViewType")
        public int viewType() {
            return ktxVulkanTexture.nviewType(this.address());
        }

        @NativeType(value="uint32_t")
        public int width() {
            return ktxVulkanTexture.nwidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int height() {
            return ktxVulkanTexture.nheight(this.address());
        }

        @NativeType(value="uint32_t")
        public int depth() {
            return ktxVulkanTexture.ndepth(this.address());
        }

        @NativeType(value="uint32_t")
        public int levelCount() {
            return ktxVulkanTexture.nlevelCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int layerCount() {
            return ktxVulkanTexture.nlayerCount(this.address());
        }

        @NativeType(value="uint64_t")
        public long allocationId() {
            return ktxVulkanTexture.nallocationId(this.address());
        }
    }
}

