/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.libdivide;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct libdivide_u16_t")
public class LibDivideU16
extends Struct<LibDivideU16>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAGIC;
    public static final int MORE;

    protected LibDivideU16(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected LibDivideU16 create(long address, @Nullable ByteBuffer container) {
        return new LibDivideU16(address, container);
    }

    public LibDivideU16(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LibDivideU16.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint16_t")
    public short magic() {
        return LibDivideU16.nmagic(this.address());
    }

    @NativeType(value="uint8_t")
    public byte more() {
        return LibDivideU16.nmore(this.address());
    }

    public LibDivideU16 magic(@NativeType(value="uint16_t") short value) {
        LibDivideU16.nmagic(this.address(), value);
        return this;
    }

    public LibDivideU16 more(@NativeType(value="uint8_t") byte value) {
        LibDivideU16.nmore(this.address(), value);
        return this;
    }

    public LibDivideU16 set(short magic, byte more) {
        this.magic(magic);
        this.more(more);
        return this;
    }

    public LibDivideU16 set(LibDivideU16 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LibDivideU16 malloc() {
        return new LibDivideU16(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static LibDivideU16 calloc() {
        return new LibDivideU16(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static LibDivideU16 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new LibDivideU16(MemoryUtil.memAddress(container), container);
    }

    public static LibDivideU16 create(long address) {
        return new LibDivideU16(address, null);
    }

    public static @Nullable LibDivideU16 createSafe(long address) {
        return address == 0L ? null : new LibDivideU16(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(LibDivideU16.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LibDivideU16.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static LibDivideU16 malloc(MemoryStack stack) {
        return new LibDivideU16(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LibDivideU16 calloc(MemoryStack stack) {
        return new LibDivideU16(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nmagic(long struct) {
        return MemoryUtil.memGetShort(struct + (long)MAGIC);
    }

    public static byte nmore(long struct) {
        return MemoryUtil.memGetByte(struct + (long)MORE);
    }

    public static void nmagic(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)MAGIC, value);
    }

    public static void nmore(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)MORE, value);
    }

    static {
        Struct.Layout layout = LibDivideU16.__struct(LibDivideU16.__member(2), LibDivideU16.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAGIC = layout.offsetof(0);
        MORE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LibDivideU16, Buffer>
    implements NativeResource {
        private static final LibDivideU16 ELEMENT_FACTORY = LibDivideU16.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected LibDivideU16 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint16_t")
        public short magic() {
            return LibDivideU16.nmagic(this.address());
        }

        @NativeType(value="uint8_t")
        public byte more() {
            return LibDivideU16.nmore(this.address());
        }

        public Buffer magic(@NativeType(value="uint16_t") short value) {
            LibDivideU16.nmagic(this.address(), value);
            return this;
        }

        public Buffer more(@NativeType(value="uint8_t") byte value) {
            LibDivideU16.nmore(this.address(), value);
            return this;
        }
    }
}

