/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.libdivide;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct libdivide_u32_t")
public class LibDivideU32
extends Struct<LibDivideU32>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAGIC;
    public static final int MORE;

    protected LibDivideU32(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected LibDivideU32 create(long address, @Nullable ByteBuffer container) {
        return new LibDivideU32(address, container);
    }

    public LibDivideU32(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LibDivideU32.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int magic() {
        return LibDivideU32.nmagic(this.address());
    }

    @NativeType(value="uint8_t")
    public byte more() {
        return LibDivideU32.nmore(this.address());
    }

    public LibDivideU32 magic(@NativeType(value="uint32_t") int value) {
        LibDivideU32.nmagic(this.address(), value);
        return this;
    }

    public LibDivideU32 more(@NativeType(value="uint8_t") byte value) {
        LibDivideU32.nmore(this.address(), value);
        return this;
    }

    public LibDivideU32 set(int magic, byte more) {
        this.magic(magic);
        this.more(more);
        return this;
    }

    public LibDivideU32 set(LibDivideU32 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LibDivideU32 malloc() {
        return new LibDivideU32(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static LibDivideU32 calloc() {
        return new LibDivideU32(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static LibDivideU32 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new LibDivideU32(MemoryUtil.memAddress(container), container);
    }

    public static LibDivideU32 create(long address) {
        return new LibDivideU32(address, null);
    }

    public static @Nullable LibDivideU32 createSafe(long address) {
        return address == 0L ? null : new LibDivideU32(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(LibDivideU32.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LibDivideU32.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static LibDivideU32 mallocStack() {
        return LibDivideU32.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LibDivideU32 callocStack() {
        return LibDivideU32.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LibDivideU32 mallocStack(MemoryStack stack) {
        return LibDivideU32.malloc(stack);
    }

    @Deprecated
    public static LibDivideU32 callocStack(MemoryStack stack) {
        return LibDivideU32.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return LibDivideU32.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return LibDivideU32.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LibDivideU32.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LibDivideU32.calloc(capacity, stack);
    }

    public static LibDivideU32 malloc(MemoryStack stack) {
        return new LibDivideU32(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LibDivideU32 calloc(MemoryStack stack) {
        return new LibDivideU32(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmagic(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAGIC);
    }

    public static byte nmore(long struct) {
        return MemoryUtil.memGetByte(struct + (long)MORE);
    }

    public static void nmagic(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAGIC, value);
    }

    public static void nmore(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)MORE, value);
    }

    static {
        Struct.Layout layout = LibDivideU32.__struct(LibDivideU32.__member(4), LibDivideU32.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAGIC = layout.offsetof(0);
        MORE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LibDivideU32, Buffer>
    implements NativeResource {
        private static final LibDivideU32 ELEMENT_FACTORY = LibDivideU32.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected LibDivideU32 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int magic() {
            return LibDivideU32.nmagic(this.address());
        }

        @NativeType(value="uint8_t")
        public byte more() {
            return LibDivideU32.nmore(this.address());
        }

        public Buffer magic(@NativeType(value="uint32_t") int value) {
            LibDivideU32.nmagic(this.address(), value);
            return this;
        }

        public Buffer more(@NativeType(value="uint8_t") byte value) {
            LibDivideU32.nmore(this.address(), value);
            return this;
        }
    }
}

