/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.lz4.LZ4FAllocFunction;
import org.lwjgl.util.lz4.LZ4FAllocFunctionI;
import org.lwjgl.util.lz4.LZ4FCallocFunction;
import org.lwjgl.util.lz4.LZ4FCallocFunctionI;
import org.lwjgl.util.lz4.LZ4FFreeFunction;
import org.lwjgl.util.lz4.LZ4FFreeFunctionI;

@NativeType(value="struct LZ4F_CustomMem")
public class LZ4FCustomMem
extends Struct<LZ4FCustomMem>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CUSTOMALLOC;
    public static final int CUSTOMCALLOC;
    public static final int CUSTOMFREE;
    public static final int OPAQUESTATE;

    protected LZ4FCustomMem(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected LZ4FCustomMem create(long address, @Nullable ByteBuffer container) {
        return new LZ4FCustomMem(address, container);
    }

    public LZ4FCustomMem(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LZ4FCustomMem.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LZ4F_AllocFunction")
    public LZ4FAllocFunction customAlloc() {
        return LZ4FCustomMem.ncustomAlloc(this.address());
    }

    @NativeType(value="LZ4F_CallocFunction")
    public @Nullable LZ4FCallocFunction customCalloc() {
        return LZ4FCustomMem.ncustomCalloc(this.address());
    }

    @NativeType(value="LZ4F_FreeFunction")
    public LZ4FFreeFunction customFree() {
        return LZ4FCustomMem.ncustomFree(this.address());
    }

    @NativeType(value="void *")
    public long opaqueState() {
        return LZ4FCustomMem.nopaqueState(this.address());
    }

    public LZ4FCustomMem customAlloc(@NativeType(value="LZ4F_AllocFunction") LZ4FAllocFunctionI value) {
        LZ4FCustomMem.ncustomAlloc(this.address(), value);
        return this;
    }

    public LZ4FCustomMem customCalloc(@NativeType(value="LZ4F_CallocFunction") @Nullable LZ4FCallocFunctionI value) {
        LZ4FCustomMem.ncustomCalloc(this.address(), value);
        return this;
    }

    public LZ4FCustomMem customFree(@NativeType(value="LZ4F_FreeFunction") LZ4FFreeFunctionI value) {
        LZ4FCustomMem.ncustomFree(this.address(), value);
        return this;
    }

    public LZ4FCustomMem opaqueState(@NativeType(value="void *") long value) {
        LZ4FCustomMem.nopaqueState(this.address(), value);
        return this;
    }

    public LZ4FCustomMem set(LZ4FAllocFunctionI customAlloc, LZ4FCallocFunctionI customCalloc, LZ4FFreeFunctionI customFree, long opaqueState) {
        this.customAlloc(customAlloc);
        this.customCalloc(customCalloc);
        this.customFree(customFree);
        this.opaqueState(opaqueState);
        return this;
    }

    public LZ4FCustomMem set(LZ4FCustomMem src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LZ4FCustomMem malloc() {
        return new LZ4FCustomMem(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static LZ4FCustomMem calloc() {
        return new LZ4FCustomMem(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static LZ4FCustomMem create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new LZ4FCustomMem(MemoryUtil.memAddress(container), container);
    }

    public static LZ4FCustomMem create(long address) {
        return new LZ4FCustomMem(address, null);
    }

    public static @Nullable LZ4FCustomMem createSafe(long address) {
        return address == 0L ? null : new LZ4FCustomMem(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(LZ4FCustomMem.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LZ4FCustomMem.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static LZ4FCustomMem malloc(MemoryStack stack) {
        return new LZ4FCustomMem(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LZ4FCustomMem calloc(MemoryStack stack) {
        return new LZ4FCustomMem(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static LZ4FAllocFunction ncustomAlloc(long struct) {
        return LZ4FAllocFunction.create(MemoryUtil.memGetAddress(struct + (long)CUSTOMALLOC));
    }

    public static @Nullable LZ4FCallocFunction ncustomCalloc(long struct) {
        return LZ4FCallocFunction.createSafe(MemoryUtil.memGetAddress(struct + (long)CUSTOMCALLOC));
    }

    public static LZ4FFreeFunction ncustomFree(long struct) {
        return LZ4FFreeFunction.create(MemoryUtil.memGetAddress(struct + (long)CUSTOMFREE));
    }

    public static long nopaqueState(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)OPAQUESTATE);
    }

    public static void ncustomAlloc(long struct, LZ4FAllocFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)CUSTOMALLOC, value.address());
    }

    public static void ncustomCalloc(long struct, @Nullable LZ4FCallocFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)CUSTOMCALLOC, MemoryUtil.memAddressSafe(value));
    }

    public static void ncustomFree(long struct, LZ4FFreeFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)CUSTOMFREE, value.address());
    }

    public static void nopaqueState(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)OPAQUESTATE, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CUSTOMALLOC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CUSTOMFREE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)OPAQUESTATE));
    }

    static {
        Struct.Layout layout = LZ4FCustomMem.__struct(LZ4FCustomMem.__member(POINTER_SIZE), LZ4FCustomMem.__member(POINTER_SIZE), LZ4FCustomMem.__member(POINTER_SIZE), LZ4FCustomMem.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CUSTOMALLOC = layout.offsetof(0);
        CUSTOMCALLOC = layout.offsetof(1);
        CUSTOMFREE = layout.offsetof(2);
        OPAQUESTATE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<LZ4FCustomMem, Buffer>
    implements NativeResource {
        private static final LZ4FCustomMem ELEMENT_FACTORY = LZ4FCustomMem.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected LZ4FCustomMem getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LZ4F_AllocFunction")
        public LZ4FAllocFunction customAlloc() {
            return LZ4FCustomMem.ncustomAlloc(this.address());
        }

        @NativeType(value="LZ4F_CallocFunction")
        public @Nullable LZ4FCallocFunction customCalloc() {
            return LZ4FCustomMem.ncustomCalloc(this.address());
        }

        @NativeType(value="LZ4F_FreeFunction")
        public LZ4FFreeFunction customFree() {
            return LZ4FCustomMem.ncustomFree(this.address());
        }

        @NativeType(value="void *")
        public long opaqueState() {
            return LZ4FCustomMem.nopaqueState(this.address());
        }

        public Buffer customAlloc(@NativeType(value="LZ4F_AllocFunction") LZ4FAllocFunctionI value) {
            LZ4FCustomMem.ncustomAlloc(this.address(), value);
            return this;
        }

        public Buffer customCalloc(@NativeType(value="LZ4F_CallocFunction") @Nullable LZ4FCallocFunctionI value) {
            LZ4FCustomMem.ncustomCalloc(this.address(), value);
            return this;
        }

        public Buffer customFree(@NativeType(value="LZ4F_FreeFunction") LZ4FFreeFunctionI value) {
            LZ4FCustomMem.ncustomFree(this.address(), value);
            return this;
        }

        public Buffer opaqueState(@NativeType(value="void *") long value) {
            LZ4FCustomMem.nopaqueState(this.address(), value);
            return this;
        }
    }
}

