/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct LZ4F_frameInfo_t")
public class LZ4FFrameInfo
extends Struct<LZ4FFrameInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BLOCKSIZEID;
    public static final int BLOCKMODE;
    public static final int CONTENTCHECKSUMFLAG;
    public static final int FRAMETYPE;
    public static final int CONTENTSIZE;
    public static final int DICTID;
    public static final int BLOCKCHECKSUMFLAG;

    protected LZ4FFrameInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected LZ4FFrameInfo create(long address, @Nullable ByteBuffer container) {
        return new LZ4FFrameInfo(address, container);
    }

    public LZ4FFrameInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LZ4FFrameInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LZ4F_blockSizeID_t")
    public int blockSizeID() {
        return LZ4FFrameInfo.nblockSizeID(this.address());
    }

    @NativeType(value="LZ4F_blockMode_t")
    public int blockMode() {
        return LZ4FFrameInfo.nblockMode(this.address());
    }

    @NativeType(value="LZ4F_contentChecksum_t")
    public int contentChecksumFlag() {
        return LZ4FFrameInfo.ncontentChecksumFlag(this.address());
    }

    @NativeType(value="LZ4F_frameType_t")
    public int frameType() {
        return LZ4FFrameInfo.nframeType(this.address());
    }

    @NativeType(value="unsigned long long")
    public long contentSize() {
        return LZ4FFrameInfo.ncontentSize(this.address());
    }

    @NativeType(value="unsigned")
    public int dictID() {
        return LZ4FFrameInfo.ndictID(this.address());
    }

    @NativeType(value="LZ4F_blockChecksum_t")
    public int blockChecksumFlag() {
        return LZ4FFrameInfo.nblockChecksumFlag(this.address());
    }

    public LZ4FFrameInfo blockSizeID(@NativeType(value="LZ4F_blockSizeID_t") int value) {
        LZ4FFrameInfo.nblockSizeID(this.address(), value);
        return this;
    }

    public LZ4FFrameInfo blockMode(@NativeType(value="LZ4F_blockMode_t") int value) {
        LZ4FFrameInfo.nblockMode(this.address(), value);
        return this;
    }

    public LZ4FFrameInfo contentChecksumFlag(@NativeType(value="LZ4F_contentChecksum_t") int value) {
        LZ4FFrameInfo.ncontentChecksumFlag(this.address(), value);
        return this;
    }

    public LZ4FFrameInfo frameType(@NativeType(value="LZ4F_frameType_t") int value) {
        LZ4FFrameInfo.nframeType(this.address(), value);
        return this;
    }

    public LZ4FFrameInfo contentSize(@NativeType(value="unsigned long long") long value) {
        LZ4FFrameInfo.ncontentSize(this.address(), value);
        return this;
    }

    public LZ4FFrameInfo dictID(@NativeType(value="unsigned") int value) {
        LZ4FFrameInfo.ndictID(this.address(), value);
        return this;
    }

    public LZ4FFrameInfo blockChecksumFlag(@NativeType(value="LZ4F_blockChecksum_t") int value) {
        LZ4FFrameInfo.nblockChecksumFlag(this.address(), value);
        return this;
    }

    public LZ4FFrameInfo set(int blockSizeID, int blockMode, int contentChecksumFlag, int frameType, long contentSize, int dictID, int blockChecksumFlag) {
        this.blockSizeID(blockSizeID);
        this.blockMode(blockMode);
        this.contentChecksumFlag(contentChecksumFlag);
        this.frameType(frameType);
        this.contentSize(contentSize);
        this.dictID(dictID);
        this.blockChecksumFlag(blockChecksumFlag);
        return this;
    }

    public LZ4FFrameInfo set(LZ4FFrameInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LZ4FFrameInfo malloc() {
        return new LZ4FFrameInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static LZ4FFrameInfo calloc() {
        return new LZ4FFrameInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static LZ4FFrameInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new LZ4FFrameInfo(MemoryUtil.memAddress(container), container);
    }

    public static LZ4FFrameInfo create(long address) {
        return new LZ4FFrameInfo(address, null);
    }

    public static @Nullable LZ4FFrameInfo createSafe(long address) {
        return address == 0L ? null : new LZ4FFrameInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(LZ4FFrameInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LZ4FFrameInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static LZ4FFrameInfo mallocStack() {
        return LZ4FFrameInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LZ4FFrameInfo callocStack() {
        return LZ4FFrameInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LZ4FFrameInfo mallocStack(MemoryStack stack) {
        return LZ4FFrameInfo.malloc(stack);
    }

    @Deprecated
    public static LZ4FFrameInfo callocStack(MemoryStack stack) {
        return LZ4FFrameInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return LZ4FFrameInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return LZ4FFrameInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LZ4FFrameInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LZ4FFrameInfo.calloc(capacity, stack);
    }

    public static LZ4FFrameInfo malloc(MemoryStack stack) {
        return new LZ4FFrameInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LZ4FFrameInfo calloc(MemoryStack stack) {
        return new LZ4FFrameInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nblockSizeID(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BLOCKSIZEID);
    }

    public static int nblockMode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BLOCKMODE);
    }

    public static int ncontentChecksumFlag(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CONTENTCHECKSUMFLAG);
    }

    public static int nframeType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRAMETYPE);
    }

    public static long ncontentSize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CONTENTSIZE);
    }

    public static int ndictID(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DICTID);
    }

    public static int nblockChecksumFlag(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BLOCKCHECKSUMFLAG);
    }

    public static void nblockSizeID(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BLOCKSIZEID, value);
    }

    public static void nblockMode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BLOCKMODE, value);
    }

    public static void ncontentChecksumFlag(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CONTENTCHECKSUMFLAG, value);
    }

    public static void nframeType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FRAMETYPE, value);
    }

    public static void ncontentSize(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)CONTENTSIZE, value);
    }

    public static void ndictID(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DICTID, value);
    }

    public static void nblockChecksumFlag(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BLOCKCHECKSUMFLAG, value);
    }

    static {
        Struct.Layout layout = LZ4FFrameInfo.__struct(LZ4FFrameInfo.__member(4), LZ4FFrameInfo.__member(4), LZ4FFrameInfo.__member(4), LZ4FFrameInfo.__member(4), LZ4FFrameInfo.__member(8), LZ4FFrameInfo.__member(4), LZ4FFrameInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BLOCKSIZEID = layout.offsetof(0);
        BLOCKMODE = layout.offsetof(1);
        CONTENTCHECKSUMFLAG = layout.offsetof(2);
        FRAMETYPE = layout.offsetof(3);
        CONTENTSIZE = layout.offsetof(4);
        DICTID = layout.offsetof(5);
        BLOCKCHECKSUMFLAG = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<LZ4FFrameInfo, Buffer>
    implements NativeResource {
        private static final LZ4FFrameInfo ELEMENT_FACTORY = LZ4FFrameInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected LZ4FFrameInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LZ4F_blockSizeID_t")
        public int blockSizeID() {
            return LZ4FFrameInfo.nblockSizeID(this.address());
        }

        @NativeType(value="LZ4F_blockMode_t")
        public int blockMode() {
            return LZ4FFrameInfo.nblockMode(this.address());
        }

        @NativeType(value="LZ4F_contentChecksum_t")
        public int contentChecksumFlag() {
            return LZ4FFrameInfo.ncontentChecksumFlag(this.address());
        }

        @NativeType(value="LZ4F_frameType_t")
        public int frameType() {
            return LZ4FFrameInfo.nframeType(this.address());
        }

        @NativeType(value="unsigned long long")
        public long contentSize() {
            return LZ4FFrameInfo.ncontentSize(this.address());
        }

        @NativeType(value="unsigned")
        public int dictID() {
            return LZ4FFrameInfo.ndictID(this.address());
        }

        @NativeType(value="LZ4F_blockChecksum_t")
        public int blockChecksumFlag() {
            return LZ4FFrameInfo.nblockChecksumFlag(this.address());
        }

        public Buffer blockSizeID(@NativeType(value="LZ4F_blockSizeID_t") int value) {
            LZ4FFrameInfo.nblockSizeID(this.address(), value);
            return this;
        }

        public Buffer blockMode(@NativeType(value="LZ4F_blockMode_t") int value) {
            LZ4FFrameInfo.nblockMode(this.address(), value);
            return this;
        }

        public Buffer contentChecksumFlag(@NativeType(value="LZ4F_contentChecksum_t") int value) {
            LZ4FFrameInfo.ncontentChecksumFlag(this.address(), value);
            return this;
        }

        public Buffer frameType(@NativeType(value="LZ4F_frameType_t") int value) {
            LZ4FFrameInfo.nframeType(this.address(), value);
            return this;
        }

        public Buffer contentSize(@NativeType(value="unsigned long long") long value) {
            LZ4FFrameInfo.ncontentSize(this.address(), value);
            return this;
        }

        public Buffer dictID(@NativeType(value="unsigned") int value) {
            LZ4FFrameInfo.ndictID(this.address(), value);
            return this;
        }

        public Buffer blockChecksumFlag(@NativeType(value="LZ4F_blockChecksum_t") int value) {
            LZ4FFrameInfo.nblockChecksumFlag(this.address(), value);
            return this;
        }
    }
}

