/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.lz4.LZ4StreamInternal;

@NativeType(value="union LZ4_stream_t")
public class LZ4Stream
extends Struct<LZ4Stream> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TABLE;
    public static final int INTERNAL_DONOTUSE;

    protected LZ4Stream(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected LZ4Stream create(long address, @Nullable ByteBuffer container) {
        return new LZ4Stream(address, container);
    }

    public LZ4Stream(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LZ4Stream.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *[LZ4_STREAM_MINSIZE]")
    public PointerBuffer table() {
        return LZ4Stream.ntable(this.address());
    }

    @NativeType(value="void *")
    public long table(int index) {
        return LZ4Stream.ntable(this.address(), index);
    }

    @NativeType(value="struct LZ4_stream_t_internal")
    public LZ4StreamInternal internal_donotuse() {
        return LZ4Stream.ninternal_donotuse(this.address());
    }

    public static LZ4Stream create(long address) {
        return new LZ4Stream(address, null);
    }

    public static @Nullable LZ4Stream createSafe(long address) {
        return address == 0L ? null : new LZ4Stream(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static PointerBuffer ntable(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)TABLE, 16416);
    }

    public static long ntable(long struct, int index) {
        return MemoryUtil.memGetAddress(struct + (long)TABLE + Checks.check(index, 16416) * (long)POINTER_SIZE);
    }

    public static LZ4StreamInternal ninternal_donotuse(long struct) {
        return LZ4StreamInternal.create(struct + (long)INTERNAL_DONOTUSE);
    }

    static {
        Struct.Layout layout = LZ4Stream.__union(LZ4Stream.__array(POINTER_SIZE, 16416), LZ4Stream.__member(LZ4StreamInternal.SIZEOF, LZ4StreamInternal.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TABLE = layout.offsetof(0);
        INTERNAL_DONOTUSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LZ4Stream, Buffer> {
        private static final LZ4Stream ELEMENT_FACTORY = LZ4Stream.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected LZ4Stream getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *[LZ4_STREAM_MINSIZE]")
        public PointerBuffer table() {
            return LZ4Stream.ntable(this.address());
        }

        @NativeType(value="void *")
        public long table(int index) {
            return LZ4Stream.ntable(this.address(), index);
        }

        @NativeType(value="struct LZ4_stream_t_internal")
        public LZ4StreamInternal internal_donotuse() {
            return LZ4Stream.ninternal_donotuse(this.address());
        }
    }
}

