/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.msdfgen;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct msdf_range")
public class MSDFGenRange
extends Struct<MSDFGenRange>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOWER;
    public static final int UPPER;

    protected MSDFGenRange(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected MSDFGenRange create(long address, @Nullable ByteBuffer container) {
        return new MSDFGenRange(address, container);
    }

    public MSDFGenRange(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), MSDFGenRange.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public double lower() {
        return MSDFGenRange.nlower(this.address());
    }

    public double upper() {
        return MSDFGenRange.nupper(this.address());
    }

    public MSDFGenRange lower(double value) {
        MSDFGenRange.nlower(this.address(), value);
        return this;
    }

    public MSDFGenRange upper(double value) {
        MSDFGenRange.nupper(this.address(), value);
        return this;
    }

    public MSDFGenRange set(double lower, double upper) {
        this.lower(lower);
        this.upper(upper);
        return this;
    }

    public MSDFGenRange set(MSDFGenRange src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static MSDFGenRange malloc() {
        return new MSDFGenRange(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static MSDFGenRange calloc() {
        return new MSDFGenRange(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static MSDFGenRange create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new MSDFGenRange(MemoryUtil.memAddress(container), container);
    }

    public static MSDFGenRange create(long address) {
        return new MSDFGenRange(address, null);
    }

    public static @Nullable MSDFGenRange createSafe(long address) {
        return address == 0L ? null : new MSDFGenRange(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(MSDFGenRange.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MSDFGenRange.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static MSDFGenRange malloc(MemoryStack stack) {
        return new MSDFGenRange(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MSDFGenRange calloc(MemoryStack stack) {
        return new MSDFGenRange(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nlower(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)LOWER);
    }

    public static double nupper(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)UPPER);
    }

    public static void nlower(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)LOWER, value);
    }

    public static void nupper(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)UPPER, value);
    }

    static {
        Struct.Layout layout = MSDFGenRange.__struct(MSDFGenRange.__member(8), MSDFGenRange.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOWER = layout.offsetof(0);
        UPPER = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<MSDFGenRange, Buffer>
    implements NativeResource {
        private static final MSDFGenRange ELEMENT_FACTORY = MSDFGenRange.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected MSDFGenRange getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double lower() {
            return MSDFGenRange.nlower(this.address());
        }

        public double upper() {
            return MSDFGenRange.nupper(this.address());
        }

        public Buffer lower(double value) {
            MSDFGenRange.nlower(this.address(), value);
            return this;
        }

        public Buffer upper(double value) {
            MSDFGenRange.nupper(this.address(), value);
            return this;
        }
    }
}

