/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.msdfgen;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.msdfgen.MSDFGenRange;
import org.lwjgl.util.msdfgen.MSDFGenVector2;

@NativeType(value="struct msdf_transform")
public class MSDFGenTransform
extends Struct<MSDFGenTransform>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SCALE;
    public static final int TRANSLATION;
    public static final int DISTANCE_MAPPING;

    protected MSDFGenTransform(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected MSDFGenTransform create(long address, @Nullable ByteBuffer container) {
        return new MSDFGenTransform(address, container);
    }

    public MSDFGenTransform(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), MSDFGenTransform.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct msdf_vector2")
    public MSDFGenVector2 scale() {
        return MSDFGenTransform.nscale(this.address());
    }

    @NativeType(value="struct msdf_vector2")
    public MSDFGenVector2 translation() {
        return MSDFGenTransform.ntranslation(this.address());
    }

    @NativeType(value="struct msdf_range")
    public MSDFGenRange distance_mapping() {
        return MSDFGenTransform.ndistance_mapping(this.address());
    }

    public MSDFGenTransform scale(@NativeType(value="struct msdf_vector2") MSDFGenVector2 value) {
        MSDFGenTransform.nscale(this.address(), value);
        return this;
    }

    public MSDFGenTransform scale(Consumer<MSDFGenVector2> consumer) {
        consumer.accept(this.scale());
        return this;
    }

    public MSDFGenTransform translation(@NativeType(value="struct msdf_vector2") MSDFGenVector2 value) {
        MSDFGenTransform.ntranslation(this.address(), value);
        return this;
    }

    public MSDFGenTransform translation(Consumer<MSDFGenVector2> consumer) {
        consumer.accept(this.translation());
        return this;
    }

    public MSDFGenTransform distance_mapping(@NativeType(value="struct msdf_range") MSDFGenRange value) {
        MSDFGenTransform.ndistance_mapping(this.address(), value);
        return this;
    }

    public MSDFGenTransform distance_mapping(Consumer<MSDFGenRange> consumer) {
        consumer.accept(this.distance_mapping());
        return this;
    }

    public MSDFGenTransform set(MSDFGenVector2 scale, MSDFGenVector2 translation, MSDFGenRange distance_mapping) {
        this.scale(scale);
        this.translation(translation);
        this.distance_mapping(distance_mapping);
        return this;
    }

    public MSDFGenTransform set(MSDFGenTransform src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static MSDFGenTransform malloc() {
        return new MSDFGenTransform(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static MSDFGenTransform calloc() {
        return new MSDFGenTransform(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static MSDFGenTransform create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new MSDFGenTransform(MemoryUtil.memAddress(container), container);
    }

    public static MSDFGenTransform create(long address) {
        return new MSDFGenTransform(address, null);
    }

    public static @Nullable MSDFGenTransform createSafe(long address) {
        return address == 0L ? null : new MSDFGenTransform(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(MSDFGenTransform.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MSDFGenTransform.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static MSDFGenTransform malloc(MemoryStack stack) {
        return new MSDFGenTransform(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MSDFGenTransform calloc(MemoryStack stack) {
        return new MSDFGenTransform(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static MSDFGenVector2 nscale(long struct) {
        return MSDFGenVector2.create(struct + (long)SCALE);
    }

    public static MSDFGenVector2 ntranslation(long struct) {
        return MSDFGenVector2.create(struct + (long)TRANSLATION);
    }

    public static MSDFGenRange ndistance_mapping(long struct) {
        return MSDFGenRange.create(struct + (long)DISTANCE_MAPPING);
    }

    public static void nscale(long struct, MSDFGenVector2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SCALE, MSDFGenVector2.SIZEOF);
    }

    public static void ntranslation(long struct, MSDFGenVector2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TRANSLATION, MSDFGenVector2.SIZEOF);
    }

    public static void ndistance_mapping(long struct, MSDFGenRange value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DISTANCE_MAPPING, MSDFGenRange.SIZEOF);
    }

    static {
        Struct.Layout layout = MSDFGenTransform.__struct(MSDFGenTransform.__member(MSDFGenVector2.SIZEOF, MSDFGenVector2.ALIGNOF), MSDFGenTransform.__member(MSDFGenVector2.SIZEOF, MSDFGenVector2.ALIGNOF), MSDFGenTransform.__member(MSDFGenRange.SIZEOF, MSDFGenRange.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SCALE = layout.offsetof(0);
        TRANSLATION = layout.offsetof(1);
        DISTANCE_MAPPING = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<MSDFGenTransform, Buffer>
    implements NativeResource {
        private static final MSDFGenTransform ELEMENT_FACTORY = MSDFGenTransform.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected MSDFGenTransform getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct msdf_vector2")
        public MSDFGenVector2 scale() {
            return MSDFGenTransform.nscale(this.address());
        }

        @NativeType(value="struct msdf_vector2")
        public MSDFGenVector2 translation() {
            return MSDFGenTransform.ntranslation(this.address());
        }

        @NativeType(value="struct msdf_range")
        public MSDFGenRange distance_mapping() {
            return MSDFGenTransform.ndistance_mapping(this.address());
        }

        public Buffer scale(@NativeType(value="struct msdf_vector2") MSDFGenVector2 value) {
            MSDFGenTransform.nscale(this.address(), value);
            return this;
        }

        public Buffer scale(Consumer<MSDFGenVector2> consumer) {
            consumer.accept(this.scale());
            return this;
        }

        public Buffer translation(@NativeType(value="struct msdf_vector2") MSDFGenVector2 value) {
            MSDFGenTransform.ntranslation(this.address(), value);
            return this;
        }

        public Buffer translation(Consumer<MSDFGenVector2> consumer) {
            consumer.accept(this.translation());
            return this;
        }

        public Buffer distance_mapping(@NativeType(value="struct msdf_range") MSDFGenRange value) {
            MSDFGenTransform.ndistance_mapping(this.address(), value);
            return this;
        }

        public Buffer distance_mapping(Consumer<MSDFGenRange> consumer) {
            consumer.accept(this.distance_mapping());
            return this;
        }
    }
}

