/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.opus;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.opus.OPCloseFunc;
import org.lwjgl.util.opus.OPCloseFuncI;
import org.lwjgl.util.opus.OPReadFunc;
import org.lwjgl.util.opus.OPReadFuncI;
import org.lwjgl.util.opus.OPSeekFunc;
import org.lwjgl.util.opus.OPSeekFuncI;
import org.lwjgl.util.opus.OPTellFunc;
import org.lwjgl.util.opus.OPTellFuncI;

public class OpusFileCallbacks
extends Struct<OpusFileCallbacks>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int READ;
    public static final int SEEK;
    public static final int TELL;
    public static final int CLOSE;

    protected OpusFileCallbacks(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected OpusFileCallbacks create(long address, @Nullable ByteBuffer container) {
        return new OpusFileCallbacks(address, container);
    }

    public OpusFileCallbacks(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OpusFileCallbacks.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="op_read_func")
    public OPReadFunc read() {
        return OpusFileCallbacks.nread(this.address());
    }

    @NativeType(value="op_seek_func")
    public @Nullable OPSeekFunc seek() {
        return OpusFileCallbacks.nseek(this.address());
    }

    @NativeType(value="op_tell_func")
    public @Nullable OPTellFunc tell() {
        return OpusFileCallbacks.ntell(this.address());
    }

    @NativeType(value="op_close_func")
    public @Nullable OPCloseFunc close$() {
        return OpusFileCallbacks.nclose$(this.address());
    }

    public OpusFileCallbacks read(@NativeType(value="op_read_func") OPReadFuncI value) {
        OpusFileCallbacks.nread(this.address(), value);
        return this;
    }

    public OpusFileCallbacks seek(@NativeType(value="op_seek_func") @Nullable OPSeekFuncI value) {
        OpusFileCallbacks.nseek(this.address(), value);
        return this;
    }

    public OpusFileCallbacks tell(@NativeType(value="op_tell_func") @Nullable OPTellFuncI value) {
        OpusFileCallbacks.ntell(this.address(), value);
        return this;
    }

    public OpusFileCallbacks close$(@NativeType(value="op_close_func") @Nullable OPCloseFuncI value) {
        OpusFileCallbacks.nclose$(this.address(), value);
        return this;
    }

    public OpusFileCallbacks set(OPReadFuncI read, OPSeekFuncI seek, OPTellFuncI tell, OPCloseFuncI close$) {
        this.read(read);
        this.seek(seek);
        this.tell(tell);
        this.close$(close$);
        return this;
    }

    public OpusFileCallbacks set(OpusFileCallbacks src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OpusFileCallbacks malloc() {
        return new OpusFileCallbacks(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OpusFileCallbacks calloc() {
        return new OpusFileCallbacks(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OpusFileCallbacks create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new OpusFileCallbacks(MemoryUtil.memAddress(container), container);
    }

    public static OpusFileCallbacks create(long address) {
        return new OpusFileCallbacks(address, null);
    }

    public static @Nullable OpusFileCallbacks createSafe(long address) {
        return address == 0L ? null : new OpusFileCallbacks(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(OpusFileCallbacks.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OpusFileCallbacks.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static OpusFileCallbacks malloc(MemoryStack stack) {
        return new OpusFileCallbacks(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OpusFileCallbacks calloc(MemoryStack stack) {
        return new OpusFileCallbacks(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OPReadFunc nread(long struct) {
        return OPReadFunc.create(MemoryUtil.memGetAddress(struct + (long)READ));
    }

    public static @Nullable OPSeekFunc nseek(long struct) {
        return OPSeekFunc.createSafe(MemoryUtil.memGetAddress(struct + (long)SEEK));
    }

    public static @Nullable OPTellFunc ntell(long struct) {
        return OPTellFunc.createSafe(MemoryUtil.memGetAddress(struct + (long)TELL));
    }

    public static @Nullable OPCloseFunc nclose$(long struct) {
        return OPCloseFunc.createSafe(MemoryUtil.memGetAddress(struct + (long)CLOSE));
    }

    public static void nread(long struct, OPReadFuncI value) {
        MemoryUtil.memPutAddress(struct + (long)READ, value.address());
    }

    public static void nseek(long struct, @Nullable OPSeekFuncI value) {
        MemoryUtil.memPutAddress(struct + (long)SEEK, MemoryUtil.memAddressSafe(value));
    }

    public static void ntell(long struct, @Nullable OPTellFuncI value) {
        MemoryUtil.memPutAddress(struct + (long)TELL, MemoryUtil.memAddressSafe(value));
    }

    public static void nclose$(long struct, @Nullable OPCloseFuncI value) {
        MemoryUtil.memPutAddress(struct + (long)CLOSE, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)READ));
    }

    static {
        Struct.Layout layout = OpusFileCallbacks.__struct(OpusFileCallbacks.__member(POINTER_SIZE), OpusFileCallbacks.__member(POINTER_SIZE), OpusFileCallbacks.__member(POINTER_SIZE), OpusFileCallbacks.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        READ = layout.offsetof(0);
        SEEK = layout.offsetof(1);
        TELL = layout.offsetof(2);
        CLOSE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OpusFileCallbacks, Buffer>
    implements NativeResource {
        private static final OpusFileCallbacks ELEMENT_FACTORY = OpusFileCallbacks.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected OpusFileCallbacks getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="op_read_func")
        public OPReadFunc read() {
            return OpusFileCallbacks.nread(this.address());
        }

        @NativeType(value="op_seek_func")
        public @Nullable OPSeekFunc seek() {
            return OpusFileCallbacks.nseek(this.address());
        }

        @NativeType(value="op_tell_func")
        public @Nullable OPTellFunc tell() {
            return OpusFileCallbacks.ntell(this.address());
        }

        @NativeType(value="op_close_func")
        public @Nullable OPCloseFunc close$() {
            return OpusFileCallbacks.nclose$(this.address());
        }

        public Buffer read(@NativeType(value="op_read_func") OPReadFuncI value) {
            OpusFileCallbacks.nread(this.address(), value);
            return this;
        }

        public Buffer seek(@NativeType(value="op_seek_func") @Nullable OPSeekFuncI value) {
            OpusFileCallbacks.nseek(this.address(), value);
            return this;
        }

        public Buffer tell(@NativeType(value="op_tell_func") @Nullable OPTellFuncI value) {
            OpusFileCallbacks.ntell(this.address(), value);
            return this;
        }

        public Buffer close$(@NativeType(value="op_close_func") @Nullable OPCloseFuncI value) {
            OpusFileCallbacks.nclose$(this.address(), value);
            return this;
        }
    }
}

