/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.par;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct par_shapes_mesh")
public class ParShapesMesh
extends Struct<ParShapesMesh> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POINTS;
    public static final int NPOINTS;
    public static final int TRIANGLES;
    public static final int NTRIANGLES;
    public static final int NORMALS;
    public static final int TCOORDS;

    protected ParShapesMesh(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected ParShapesMesh create(long address, @Nullable ByteBuffer container) {
        return new ParShapesMesh(address, container);
    }

    public ParShapesMesh(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ParShapesMesh.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float *")
    public FloatBuffer points(int capacity) {
        return ParShapesMesh.npoints(this.address(), capacity);
    }

    public int npoints() {
        return ParShapesMesh.nnpoints(this.address());
    }

    @NativeType(value="PAR_SHAPES_T *")
    public IntBuffer triangles(int capacity) {
        return ParShapesMesh.ntriangles(this.address(), capacity);
    }

    public int ntriangles() {
        return ParShapesMesh.nntriangles(this.address());
    }

    @NativeType(value="float *")
    public @Nullable FloatBuffer normals(int capacity) {
        return ParShapesMesh.nnormals(this.address(), capacity);
    }

    @NativeType(value="float *")
    public @Nullable FloatBuffer tcoords(int capacity) {
        return ParShapesMesh.ntcoords(this.address(), capacity);
    }

    public static ParShapesMesh create(long address) {
        return new ParShapesMesh(address, null);
    }

    public static @Nullable ParShapesMesh createSafe(long address) {
        return address == 0L ? null : new ParShapesMesh(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FloatBuffer npoints(long struct, int capacity) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)POINTS), capacity);
    }

    public static int nnpoints(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NPOINTS);
    }

    public static IntBuffer ntriangles(long struct, int capacity) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)TRIANGLES), capacity);
    }

    public static int nntriangles(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NTRIANGLES);
    }

    public static @Nullable FloatBuffer nnormals(long struct, int capacity) {
        return MemoryUtil.memFloatBufferSafe(MemoryUtil.memGetAddress(struct + (long)NORMALS), capacity);
    }

    public static @Nullable FloatBuffer ntcoords(long struct, int capacity) {
        return MemoryUtil.memFloatBufferSafe(MemoryUtil.memGetAddress(struct + (long)TCOORDS), capacity);
    }

    static {
        Struct.Layout layout = ParShapesMesh.__struct(ParShapesMesh.__member(POINTER_SIZE), ParShapesMesh.__member(4), ParShapesMesh.__member(POINTER_SIZE), ParShapesMesh.__member(4), ParShapesMesh.__member(POINTER_SIZE), ParShapesMesh.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POINTS = layout.offsetof(0);
        NPOINTS = layout.offsetof(1);
        TRIANGLES = layout.offsetof(2);
        NTRIANGLES = layout.offsetof(3);
        NORMALS = layout.offsetof(4);
        TCOORDS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<ParShapesMesh, Buffer> {
        private static final ParShapesMesh ELEMENT_FACTORY = ParShapesMesh.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected ParShapesMesh getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float *")
        public FloatBuffer points(int capacity) {
            return ParShapesMesh.npoints(this.address(), capacity);
        }

        public int npoints() {
            return ParShapesMesh.nnpoints(this.address());
        }

        @NativeType(value="PAR_SHAPES_T *")
        public IntBuffer triangles(int capacity) {
            return ParShapesMesh.ntriangles(this.address(), capacity);
        }

        public int ntriangles() {
            return ParShapesMesh.nntriangles(this.address());
        }

        @NativeType(value="float *")
        public @Nullable FloatBuffer normals(int capacity) {
            return ParShapesMesh.nnormals(this.address(), capacity);
        }

        @NativeType(value="float *")
        public @Nullable FloatBuffer tcoords(int capacity) {
            return ParShapesMesh.ntcoords(this.address(), capacity);
        }
    }
}

