/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.remotery;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.util.remotery.RMTProperty;

@NativeType(value="struct rmtPropertyIterator")
public class RMTPropertyIterator
extends Struct<RMTPropertyIterator>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PROPERTY;
    public static final int INITIAL;

    protected RMTPropertyIterator(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected RMTPropertyIterator create(long address, @Nullable ByteBuffer container) {
        return new RMTPropertyIterator(address, container);
    }

    public RMTPropertyIterator(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), RMTPropertyIterator.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="rmtProperty *")
    public RMTProperty property() {
        return RMTPropertyIterator.nproperty(this.address());
    }

    public static RMTPropertyIterator malloc() {
        return new RMTPropertyIterator(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static RMTPropertyIterator calloc() {
        return new RMTPropertyIterator(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static RMTPropertyIterator create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new RMTPropertyIterator(MemoryUtil.memAddress(container), container);
    }

    public static RMTPropertyIterator create(long address) {
        return new RMTPropertyIterator(address, null);
    }

    public static @Nullable RMTPropertyIterator createSafe(long address) {
        return address == 0L ? null : new RMTPropertyIterator(address, null);
    }

    public static RMTPropertyIterator malloc(MemoryStack stack) {
        return new RMTPropertyIterator(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static RMTPropertyIterator calloc(MemoryStack stack) {
        return new RMTPropertyIterator(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static RMTProperty nproperty(long struct) {
        return RMTProperty.create(MemoryUtil.memGetAddress(struct + (long)PROPERTY));
    }

    public static RMTProperty ninitial(long struct) {
        return RMTProperty.create(MemoryUtil.memGetAddress(struct + (long)INITIAL));
    }

    static {
        Struct.Layout layout = RMTPropertyIterator.__struct(RMTPropertyIterator.__member(POINTER_SIZE), RMTPropertyIterator.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PROPERTY = layout.offsetof(0);
        INITIAL = layout.offsetof(1);
    }
}

