/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.remotery;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="union rmtPropertyValue")
public class RMTPropertyValue
extends Struct<RMTPropertyValue>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BOOL;
    public static final int S32;
    public static final int U32;
    public static final int F32;
    public static final int S64;
    public static final int U64;
    public static final int F64;

    protected RMTPropertyValue(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected RMTPropertyValue create(long address, @Nullable ByteBuffer container) {
        return new RMTPropertyValue(address, container);
    }

    public RMTPropertyValue(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), RMTPropertyValue.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="rmtBool")
    public boolean Bool() {
        return RMTPropertyValue.nBool(this.address()) != 0;
    }

    @NativeType(value="rmtS32")
    public int S32() {
        return RMTPropertyValue.nS32(this.address());
    }

    @NativeType(value="rmtU32")
    public int U32() {
        return RMTPropertyValue.nU32(this.address());
    }

    @NativeType(value="rmtF32")
    public float F32() {
        return RMTPropertyValue.nF32(this.address());
    }

    @NativeType(value="rmtS64")
    public long S64() {
        return RMTPropertyValue.nS64(this.address());
    }

    @NativeType(value="rmtU64")
    public long U64() {
        return RMTPropertyValue.nU64(this.address());
    }

    @NativeType(value="rmtF64")
    public double F64() {
        return RMTPropertyValue.nF64(this.address());
    }

    public RMTPropertyValue Bool(@NativeType(value="rmtBool") boolean value) {
        RMTPropertyValue.nBool(this.address(), value ? 1 : 0);
        return this;
    }

    public RMTPropertyValue S32(@NativeType(value="rmtS32") int value) {
        RMTPropertyValue.nS32(this.address(), value);
        return this;
    }

    public RMTPropertyValue U32(@NativeType(value="rmtU32") int value) {
        RMTPropertyValue.nU32(this.address(), value);
        return this;
    }

    public RMTPropertyValue F32(@NativeType(value="rmtF32") float value) {
        RMTPropertyValue.nF32(this.address(), value);
        return this;
    }

    public RMTPropertyValue S64(@NativeType(value="rmtS64") long value) {
        RMTPropertyValue.nS64(this.address(), value);
        return this;
    }

    public RMTPropertyValue U64(@NativeType(value="rmtU64") long value) {
        RMTPropertyValue.nU64(this.address(), value);
        return this;
    }

    public RMTPropertyValue F64(@NativeType(value="rmtF64") double value) {
        RMTPropertyValue.nF64(this.address(), value);
        return this;
    }

    public RMTPropertyValue set(RMTPropertyValue src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static RMTPropertyValue malloc() {
        return new RMTPropertyValue(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static RMTPropertyValue calloc() {
        return new RMTPropertyValue(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static RMTPropertyValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new RMTPropertyValue(MemoryUtil.memAddress(container), container);
    }

    public static RMTPropertyValue create(long address) {
        return new RMTPropertyValue(address, null);
    }

    public static @Nullable RMTPropertyValue createSafe(long address) {
        return address == 0L ? null : new RMTPropertyValue(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(RMTPropertyValue.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = RMTPropertyValue.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static RMTPropertyValue malloc(MemoryStack stack) {
        return new RMTPropertyValue(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static RMTPropertyValue calloc(MemoryStack stack) {
        return new RMTPropertyValue(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nBool(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BOOL);
    }

    public static int nS32(long struct) {
        return MemoryUtil.memGetInt(struct + (long)S32);
    }

    public static int nU32(long struct) {
        return MemoryUtil.memGetInt(struct + (long)U32);
    }

    public static float nF32(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)F32);
    }

    public static long nS64(long struct) {
        return MemoryUtil.memGetLong(struct + (long)S64);
    }

    public static long nU64(long struct) {
        return MemoryUtil.memGetLong(struct + (long)U64);
    }

    public static double nF64(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)F64);
    }

    public static void nBool(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BOOL, value);
    }

    public static void nS32(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)S32, value);
    }

    public static void nU32(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)U32, value);
    }

    public static void nF32(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)F32, value);
    }

    public static void nS64(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)S64, value);
    }

    public static void nU64(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)U64, value);
    }

    public static void nF64(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)F64, value);
    }

    static {
        Struct.Layout layout = RMTPropertyValue.__union(RMTPropertyValue.__member(4), RMTPropertyValue.__member(4), RMTPropertyValue.__member(4), RMTPropertyValue.__member(4), RMTPropertyValue.__member(8), RMTPropertyValue.__member(8), RMTPropertyValue.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BOOL = layout.offsetof(0);
        S32 = layout.offsetof(1);
        U32 = layout.offsetof(2);
        F32 = layout.offsetof(3);
        S64 = layout.offsetof(4);
        U64 = layout.offsetof(5);
        F64 = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<RMTPropertyValue, Buffer>
    implements NativeResource {
        private static final RMTPropertyValue ELEMENT_FACTORY = RMTPropertyValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected RMTPropertyValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="rmtBool")
        public boolean Bool() {
            return RMTPropertyValue.nBool(this.address()) != 0;
        }

        @NativeType(value="rmtS32")
        public int S32() {
            return RMTPropertyValue.nS32(this.address());
        }

        @NativeType(value="rmtU32")
        public int U32() {
            return RMTPropertyValue.nU32(this.address());
        }

        @NativeType(value="rmtF32")
        public float F32() {
            return RMTPropertyValue.nF32(this.address());
        }

        @NativeType(value="rmtS64")
        public long S64() {
            return RMTPropertyValue.nS64(this.address());
        }

        @NativeType(value="rmtU64")
        public long U64() {
            return RMTPropertyValue.nU64(this.address());
        }

        @NativeType(value="rmtF64")
        public double F64() {
            return RMTPropertyValue.nF64(this.address());
        }

        public Buffer Bool(@NativeType(value="rmtBool") boolean value) {
            RMTPropertyValue.nBool(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer S32(@NativeType(value="rmtS32") int value) {
            RMTPropertyValue.nS32(this.address(), value);
            return this;
        }

        public Buffer U32(@NativeType(value="rmtU32") int value) {
            RMTPropertyValue.nU32(this.address(), value);
            return this;
        }

        public Buffer F32(@NativeType(value="rmtF32") float value) {
            RMTPropertyValue.nF32(this.address(), value);
            return this;
        }

        public Buffer S64(@NativeType(value="rmtS64") long value) {
            RMTPropertyValue.nS64(this.address(), value);
            return this;
        }

        public Buffer U64(@NativeType(value="rmtU64") long value) {
            RMTPropertyValue.nU64(this.address(), value);
            return this;
        }

        public Buffer F64(@NativeType(value="rmtF64") double value) {
            RMTPropertyValue.nF64(this.address(), value);
            return this;
        }
    }
}

