/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.remotery;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct rmtSampleIterator")
public class RMTSampleIterator
extends Struct<RMTSampleIterator>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLE;
    public static final int INITIAL;

    protected RMTSampleIterator(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected RMTSampleIterator create(long address, @Nullable ByteBuffer container) {
        return new RMTSampleIterator(address, container);
    }

    public RMTSampleIterator(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), RMTSampleIterator.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="rmtSample *")
    public long sample() {
        return RMTSampleIterator.nsample(this.address());
    }

    public static RMTSampleIterator malloc() {
        return new RMTSampleIterator(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static RMTSampleIterator calloc() {
        return new RMTSampleIterator(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static RMTSampleIterator create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new RMTSampleIterator(MemoryUtil.memAddress(container), container);
    }

    public static RMTSampleIterator create(long address) {
        return new RMTSampleIterator(address, null);
    }

    public static @Nullable RMTSampleIterator createSafe(long address) {
        return address == 0L ? null : new RMTSampleIterator(address, null);
    }

    public static RMTSampleIterator malloc(MemoryStack stack) {
        return new RMTSampleIterator(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static RMTSampleIterator calloc(MemoryStack stack) {
        return new RMTSampleIterator(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static long nsample(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SAMPLE);
    }

    public static long ninitial(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)INITIAL);
    }

    static {
        Struct.Layout layout = RMTSampleIterator.__struct(RMTSampleIterator.__member(POINTER_SIZE), RMTSampleIterator.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLE = layout.offsetof(0);
        INITIAL = layout.offsetof(1);
    }
}

