/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_buffer_range")
public class SpvcBufferRange
extends Struct<SpvcBufferRange>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INDEX;
    public static final int OFFSET;
    public static final int RANGE;

    protected SpvcBufferRange(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SpvcBufferRange create(long address, @Nullable ByteBuffer container) {
        return new SpvcBufferRange(address, container);
    }

    public SpvcBufferRange(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SpvcBufferRange.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int index() {
        return SpvcBufferRange.nindex(this.address());
    }

    @NativeType(value="size_t")
    public long offset() {
        return SpvcBufferRange.noffset(this.address());
    }

    @NativeType(value="size_t")
    public long range() {
        return SpvcBufferRange.nrange(this.address());
    }

    public SpvcBufferRange index(@NativeType(value="unsigned int") int value) {
        SpvcBufferRange.nindex(this.address(), value);
        return this;
    }

    public SpvcBufferRange offset(@NativeType(value="size_t") long value) {
        SpvcBufferRange.noffset(this.address(), value);
        return this;
    }

    public SpvcBufferRange range(@NativeType(value="size_t") long value) {
        SpvcBufferRange.nrange(this.address(), value);
        return this;
    }

    public SpvcBufferRange set(int index, long offset, long range) {
        this.index(index);
        this.offset(offset);
        this.range(range);
        return this;
    }

    public SpvcBufferRange set(SpvcBufferRange src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SpvcBufferRange malloc() {
        return new SpvcBufferRange(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SpvcBufferRange calloc() {
        return new SpvcBufferRange(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SpvcBufferRange create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SpvcBufferRange(MemoryUtil.memAddress(container), container);
    }

    public static SpvcBufferRange create(long address) {
        return new SpvcBufferRange(address, null);
    }

    public static @Nullable SpvcBufferRange createSafe(long address) {
        return address == 0L ? null : new SpvcBufferRange(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SpvcBufferRange.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcBufferRange.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SpvcBufferRange malloc(MemoryStack stack) {
        return new SpvcBufferRange(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SpvcBufferRange calloc(MemoryStack stack) {
        return new SpvcBufferRange(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nindex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INDEX);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)OFFSET);
    }

    public static long nrange(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)RANGE);
    }

    public static void nindex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INDEX, value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)OFFSET, value);
    }

    public static void nrange(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)RANGE, value);
    }

    static {
        Struct.Layout layout = SpvcBufferRange.__struct(SpvcBufferRange.__member(4), SpvcBufferRange.__member(POINTER_SIZE), SpvcBufferRange.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INDEX = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        RANGE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<SpvcBufferRange, Buffer>
    implements NativeResource {
        private static final SpvcBufferRange ELEMENT_FACTORY = SpvcBufferRange.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SpvcBufferRange getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int index() {
            return SpvcBufferRange.nindex(this.address());
        }

        @NativeType(value="size_t")
        public long offset() {
            return SpvcBufferRange.noffset(this.address());
        }

        @NativeType(value="size_t")
        public long range() {
            return SpvcBufferRange.nrange(this.address());
        }

        public Buffer index(@NativeType(value="unsigned int") int value) {
            SpvcBufferRange.nindex(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="size_t") long value) {
            SpvcBufferRange.noffset(this.address(), value);
            return this;
        }

        public Buffer range(@NativeType(value="size_t") long value) {
            SpvcBufferRange.nrange(this.address(), value);
            return this;
        }
    }
}

