/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.vma.VmaAllocationInfo;

public class VmaAllocationInfo2
extends Struct<VmaAllocationInfo2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOCATIONINFO;
    public static final int BLOCKSIZE;
    public static final int DEDICATEDMEMORY;

    protected VmaAllocationInfo2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VmaAllocationInfo2 create(long address, @Nullable ByteBuffer container) {
        return new VmaAllocationInfo2(address, container);
    }

    public VmaAllocationInfo2(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaAllocationInfo2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VmaAllocationInfo allocationInfo() {
        return VmaAllocationInfo2.nallocationInfo(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long blockSize() {
        return VmaAllocationInfo2.nblockSize(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean dedicatedMemory() {
        return VmaAllocationInfo2.ndedicatedMemory(this.address()) != 0;
    }

    public static VmaAllocationInfo2 malloc() {
        return new VmaAllocationInfo2(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VmaAllocationInfo2 calloc() {
        return new VmaAllocationInfo2(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VmaAllocationInfo2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VmaAllocationInfo2(MemoryUtil.memAddress(container), container);
    }

    public static VmaAllocationInfo2 create(long address) {
        return new VmaAllocationInfo2(address, null);
    }

    public static @Nullable VmaAllocationInfo2 createSafe(long address) {
        return address == 0L ? null : new VmaAllocationInfo2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VmaAllocationInfo2.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaAllocationInfo2.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VmaAllocationInfo2 malloc(MemoryStack stack) {
        return new VmaAllocationInfo2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VmaAllocationInfo2 calloc(MemoryStack stack) {
        return new VmaAllocationInfo2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VmaAllocationInfo nallocationInfo(long struct) {
        return VmaAllocationInfo.create(struct + (long)ALLOCATIONINFO);
    }

    public static long nblockSize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BLOCKSIZE);
    }

    public static int ndedicatedMemory(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEDICATEDMEMORY);
    }

    static {
        Struct.Layout layout = VmaAllocationInfo2.__struct(VmaAllocationInfo2.__member(VmaAllocationInfo.SIZEOF, VmaAllocationInfo.ALIGNOF), VmaAllocationInfo2.__member(8), VmaAllocationInfo2.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ALLOCATIONINFO = layout.offsetof(0);
        BLOCKSIZE = layout.offsetof(1);
        DEDICATEDMEMORY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaAllocationInfo2, Buffer>
    implements NativeResource {
        private static final VmaAllocationInfo2 ELEMENT_FACTORY = VmaAllocationInfo2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VmaAllocationInfo2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VmaAllocationInfo allocationInfo() {
            return VmaAllocationInfo2.nallocationInfo(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long blockSize() {
            return VmaAllocationInfo2.nblockSize(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean dedicatedMemory() {
            return VmaAllocationInfo2.ndedicatedMemory(this.address()) != 0;
        }
    }
}

