/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaAllocatorInfo
extends Struct<VmaAllocatorInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INSTANCE;
    public static final int PHYSICALDEVICE;
    public static final int DEVICE;

    protected VmaAllocatorInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VmaAllocatorInfo create(long address, @Nullable ByteBuffer container) {
        return new VmaAllocatorInfo(address, container);
    }

    public VmaAllocatorInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaAllocatorInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkInstance")
    public long instance() {
        return VmaAllocatorInfo.ninstance(this.address());
    }

    @NativeType(value="VkPhysicalDevice")
    public long physicalDevice() {
        return VmaAllocatorInfo.nphysicalDevice(this.address());
    }

    @NativeType(value="VkDevice")
    public long device() {
        return VmaAllocatorInfo.ndevice(this.address());
    }

    public static VmaAllocatorInfo malloc() {
        return new VmaAllocatorInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VmaAllocatorInfo calloc() {
        return new VmaAllocatorInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VmaAllocatorInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VmaAllocatorInfo(MemoryUtil.memAddress(container), container);
    }

    public static VmaAllocatorInfo create(long address) {
        return new VmaAllocatorInfo(address, null);
    }

    public static @Nullable VmaAllocatorInfo createSafe(long address) {
        return address == 0L ? null : new VmaAllocatorInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VmaAllocatorInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaAllocatorInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VmaAllocatorInfo malloc(MemoryStack stack) {
        return new VmaAllocatorInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VmaAllocatorInfo calloc(MemoryStack stack) {
        return new VmaAllocatorInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ninstance(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)INSTANCE);
    }

    public static long nphysicalDevice(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PHYSICALDEVICE);
    }

    public static long ndevice(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DEVICE);
    }

    static {
        Struct.Layout layout = VmaAllocatorInfo.__struct(VmaAllocatorInfo.__member(POINTER_SIZE), VmaAllocatorInfo.__member(POINTER_SIZE), VmaAllocatorInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INSTANCE = layout.offsetof(0);
        PHYSICALDEVICE = layout.offsetof(1);
        DEVICE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaAllocatorInfo, Buffer>
    implements NativeResource {
        private static final VmaAllocatorInfo ELEMENT_FACTORY = VmaAllocatorInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VmaAllocatorInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkInstance")
        public long instance() {
            return VmaAllocatorInfo.ninstance(this.address());
        }

        @NativeType(value="VkPhysicalDevice")
        public long physicalDevice() {
            return VmaAllocatorInfo.nphysicalDevice(this.address());
        }

        @NativeType(value="VkDevice")
        public long device() {
            return VmaAllocatorInfo.ndevice(this.address());
        }
    }
}

