/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.vma.VmaCheckDefragmentationBreakFunction;
import org.lwjgl.util.vma.VmaCheckDefragmentationBreakFunctionI;

public class VmaDefragmentationInfo
extends Struct<VmaDefragmentationInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int POOL;
    public static final int MAXBYTESPERPASS;
    public static final int MAXALLOCATIONSPERPASS;
    public static final int PFNBREAKCALLBACK;
    public static final int PBREAKCALLBACKUSERDATA;

    protected VmaDefragmentationInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VmaDefragmentationInfo create(long address, @Nullable ByteBuffer container) {
        return new VmaDefragmentationInfo(address, container);
    }

    public VmaDefragmentationInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaDefragmentationInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VmaDefragmentationFlags")
    public int flags() {
        return VmaDefragmentationInfo.nflags(this.address());
    }

    @NativeType(value="VmaPool")
    public long pool() {
        return VmaDefragmentationInfo.npool(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long maxBytesPerPass() {
        return VmaDefragmentationInfo.nmaxBytesPerPass(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxAllocationsPerPass() {
        return VmaDefragmentationInfo.nmaxAllocationsPerPass(this.address());
    }

    @NativeType(value="PFN_vmaCheckDefragmentationBreakFunction")
    public @Nullable VmaCheckDefragmentationBreakFunction pfnBreakCallback() {
        return VmaDefragmentationInfo.npfnBreakCallback(this.address());
    }

    @NativeType(value="void *")
    public long pBreakCallbackUserData() {
        return VmaDefragmentationInfo.npBreakCallbackUserData(this.address());
    }

    public VmaDefragmentationInfo flags(@NativeType(value="VmaDefragmentationFlags") int value) {
        VmaDefragmentationInfo.nflags(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo pool(@NativeType(value="VmaPool") long value) {
        VmaDefragmentationInfo.npool(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo maxBytesPerPass(@NativeType(value="VkDeviceSize") long value) {
        VmaDefragmentationInfo.nmaxBytesPerPass(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo maxAllocationsPerPass(@NativeType(value="uint32_t") int value) {
        VmaDefragmentationInfo.nmaxAllocationsPerPass(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo pfnBreakCallback(@NativeType(value="PFN_vmaCheckDefragmentationBreakFunction") @Nullable VmaCheckDefragmentationBreakFunctionI value) {
        VmaDefragmentationInfo.npfnBreakCallback(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo pBreakCallbackUserData(@NativeType(value="void *") long value) {
        VmaDefragmentationInfo.npBreakCallbackUserData(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo set(int flags, long pool, long maxBytesPerPass, int maxAllocationsPerPass, VmaCheckDefragmentationBreakFunctionI pfnBreakCallback, long pBreakCallbackUserData) {
        this.flags(flags);
        this.pool(pool);
        this.maxBytesPerPass(maxBytesPerPass);
        this.maxAllocationsPerPass(maxAllocationsPerPass);
        this.pfnBreakCallback(pfnBreakCallback);
        this.pBreakCallbackUserData(pBreakCallbackUserData);
        return this;
    }

    public VmaDefragmentationInfo set(VmaDefragmentationInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VmaDefragmentationInfo malloc() {
        return new VmaDefragmentationInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VmaDefragmentationInfo calloc() {
        return new VmaDefragmentationInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VmaDefragmentationInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VmaDefragmentationInfo(MemoryUtil.memAddress(container), container);
    }

    public static VmaDefragmentationInfo create(long address) {
        return new VmaDefragmentationInfo(address, null);
    }

    public static @Nullable VmaDefragmentationInfo createSafe(long address) {
        return address == 0L ? null : new VmaDefragmentationInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VmaDefragmentationInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaDefragmentationInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VmaDefragmentationInfo mallocStack() {
        return VmaDefragmentationInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDefragmentationInfo callocStack() {
        return VmaDefragmentationInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDefragmentationInfo mallocStack(MemoryStack stack) {
        return VmaDefragmentationInfo.malloc(stack);
    }

    @Deprecated
    public static VmaDefragmentationInfo callocStack(MemoryStack stack) {
        return VmaDefragmentationInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VmaDefragmentationInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VmaDefragmentationInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationInfo.calloc(capacity, stack);
    }

    public static VmaDefragmentationInfo malloc(MemoryStack stack) {
        return new VmaDefragmentationInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VmaDefragmentationInfo calloc(MemoryStack stack) {
        return new VmaDefragmentationInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long npool(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)POOL);
    }

    public static long nmaxBytesPerPass(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MAXBYTESPERPASS);
    }

    public static int nmaxAllocationsPerPass(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXALLOCATIONSPERPASS);
    }

    public static @Nullable VmaCheckDefragmentationBreakFunction npfnBreakCallback(long struct) {
        return VmaCheckDefragmentationBreakFunction.createSafe(MemoryUtil.memGetAddress(struct + (long)PFNBREAKCALLBACK));
    }

    public static long npBreakCallbackUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PBREAKCALLBACKUSERDATA);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void npool(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)POOL, value);
    }

    public static void nmaxBytesPerPass(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MAXBYTESPERPASS, value);
    }

    public static void nmaxAllocationsPerPass(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAXALLOCATIONSPERPASS, value);
    }

    public static void npfnBreakCallback(long struct, @Nullable VmaCheckDefragmentationBreakFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNBREAKCALLBACK, MemoryUtil.memAddressSafe(value));
    }

    public static void npBreakCallbackUserData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PBREAKCALLBACKUSERDATA, value);
    }

    static {
        Struct.Layout layout = VmaDefragmentationInfo.__struct(VmaDefragmentationInfo.__member(4), VmaDefragmentationInfo.__member(POINTER_SIZE), VmaDefragmentationInfo.__member(8), VmaDefragmentationInfo.__member(4), VmaDefragmentationInfo.__member(POINTER_SIZE), VmaDefragmentationInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        POOL = layout.offsetof(1);
        MAXBYTESPERPASS = layout.offsetof(2);
        MAXALLOCATIONSPERPASS = layout.offsetof(3);
        PFNBREAKCALLBACK = layout.offsetof(4);
        PBREAKCALLBACKUSERDATA = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VmaDefragmentationInfo, Buffer>
    implements NativeResource {
        private static final VmaDefragmentationInfo ELEMENT_FACTORY = VmaDefragmentationInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VmaDefragmentationInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VmaDefragmentationFlags")
        public int flags() {
            return VmaDefragmentationInfo.nflags(this.address());
        }

        @NativeType(value="VmaPool")
        public long pool() {
            return VmaDefragmentationInfo.npool(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long maxBytesPerPass() {
            return VmaDefragmentationInfo.nmaxBytesPerPass(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxAllocationsPerPass() {
            return VmaDefragmentationInfo.nmaxAllocationsPerPass(this.address());
        }

        @NativeType(value="PFN_vmaCheckDefragmentationBreakFunction")
        public @Nullable VmaCheckDefragmentationBreakFunction pfnBreakCallback() {
            return VmaDefragmentationInfo.npfnBreakCallback(this.address());
        }

        @NativeType(value="void *")
        public long pBreakCallbackUserData() {
            return VmaDefragmentationInfo.npBreakCallbackUserData(this.address());
        }

        public Buffer flags(@NativeType(value="VmaDefragmentationFlags") int value) {
            VmaDefragmentationInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pool(@NativeType(value="VmaPool") long value) {
            VmaDefragmentationInfo.npool(this.address(), value);
            return this;
        }

        public Buffer maxBytesPerPass(@NativeType(value="VkDeviceSize") long value) {
            VmaDefragmentationInfo.nmaxBytesPerPass(this.address(), value);
            return this;
        }

        public Buffer maxAllocationsPerPass(@NativeType(value="uint32_t") int value) {
            VmaDefragmentationInfo.nmaxAllocationsPerPass(this.address(), value);
            return this;
        }

        public Buffer pfnBreakCallback(@NativeType(value="PFN_vmaCheckDefragmentationBreakFunction") @Nullable VmaCheckDefragmentationBreakFunctionI value) {
            VmaDefragmentationInfo.npfnBreakCallback(this.address(), value);
            return this;
        }

        public Buffer pBreakCallbackUserData(@NativeType(value="void *") long value) {
            VmaDefragmentationInfo.npBreakCallbackUserData(this.address(), value);
            return this;
        }
    }
}

