/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.vma.VmaAllocateDeviceMemoryFunction;
import org.lwjgl.util.vma.VmaAllocateDeviceMemoryFunctionI;
import org.lwjgl.util.vma.VmaFreeDeviceMemoryFunction;
import org.lwjgl.util.vma.VmaFreeDeviceMemoryFunctionI;

public class VmaDeviceMemoryCallbacks
extends Struct<VmaDeviceMemoryCallbacks>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PFNALLOCATE;
    public static final int PFNFREE;
    public static final int PUSERDATA;

    protected VmaDeviceMemoryCallbacks(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VmaDeviceMemoryCallbacks create(long address, @Nullable ByteBuffer container) {
        return new VmaDeviceMemoryCallbacks(address, container);
    }

    public VmaDeviceMemoryCallbacks(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaDeviceMemoryCallbacks.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="PFN_vmaAllocateDeviceMemoryFunction")
    public @Nullable VmaAllocateDeviceMemoryFunction pfnAllocate() {
        return VmaDeviceMemoryCallbacks.npfnAllocate(this.address());
    }

    @NativeType(value="PFN_vmaFreeDeviceMemoryFunction")
    public @Nullable VmaFreeDeviceMemoryFunction pfnFree() {
        return VmaDeviceMemoryCallbacks.npfnFree(this.address());
    }

    @NativeType(value="void *")
    public long pUserData() {
        return VmaDeviceMemoryCallbacks.npUserData(this.address());
    }

    public VmaDeviceMemoryCallbacks pfnAllocate(@NativeType(value="PFN_vmaAllocateDeviceMemoryFunction") @Nullable VmaAllocateDeviceMemoryFunctionI value) {
        VmaDeviceMemoryCallbacks.npfnAllocate(this.address(), value);
        return this;
    }

    public VmaDeviceMemoryCallbacks pfnFree(@NativeType(value="PFN_vmaFreeDeviceMemoryFunction") @Nullable VmaFreeDeviceMemoryFunctionI value) {
        VmaDeviceMemoryCallbacks.npfnFree(this.address(), value);
        return this;
    }

    public VmaDeviceMemoryCallbacks pUserData(@NativeType(value="void *") long value) {
        VmaDeviceMemoryCallbacks.npUserData(this.address(), value);
        return this;
    }

    public VmaDeviceMemoryCallbacks set(VmaAllocateDeviceMemoryFunctionI pfnAllocate, VmaFreeDeviceMemoryFunctionI pfnFree, long pUserData) {
        this.pfnAllocate(pfnAllocate);
        this.pfnFree(pfnFree);
        this.pUserData(pUserData);
        return this;
    }

    public VmaDeviceMemoryCallbacks set(VmaDeviceMemoryCallbacks src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VmaDeviceMemoryCallbacks malloc() {
        return new VmaDeviceMemoryCallbacks(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VmaDeviceMemoryCallbacks calloc() {
        return new VmaDeviceMemoryCallbacks(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VmaDeviceMemoryCallbacks create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VmaDeviceMemoryCallbacks(MemoryUtil.memAddress(container), container);
    }

    public static VmaDeviceMemoryCallbacks create(long address) {
        return new VmaDeviceMemoryCallbacks(address, null);
    }

    public static @Nullable VmaDeviceMemoryCallbacks createSafe(long address) {
        return address == 0L ? null : new VmaDeviceMemoryCallbacks(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VmaDeviceMemoryCallbacks.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaDeviceMemoryCallbacks.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VmaDeviceMemoryCallbacks mallocStack() {
        return VmaDeviceMemoryCallbacks.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDeviceMemoryCallbacks callocStack() {
        return VmaDeviceMemoryCallbacks.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDeviceMemoryCallbacks mallocStack(MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.malloc(stack);
    }

    @Deprecated
    public static VmaDeviceMemoryCallbacks callocStack(MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VmaDeviceMemoryCallbacks.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VmaDeviceMemoryCallbacks.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.calloc(capacity, stack);
    }

    public static VmaDeviceMemoryCallbacks malloc(MemoryStack stack) {
        return new VmaDeviceMemoryCallbacks(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VmaDeviceMemoryCallbacks calloc(MemoryStack stack) {
        return new VmaDeviceMemoryCallbacks(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static @Nullable VmaAllocateDeviceMemoryFunction npfnAllocate(long struct) {
        return VmaAllocateDeviceMemoryFunction.createSafe(MemoryUtil.memGetAddress(struct + (long)PFNALLOCATE));
    }

    public static @Nullable VmaFreeDeviceMemoryFunction npfnFree(long struct) {
        return VmaFreeDeviceMemoryFunction.createSafe(MemoryUtil.memGetAddress(struct + (long)PFNFREE));
    }

    public static long npUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PUSERDATA);
    }

    public static void npfnAllocate(long struct, @Nullable VmaAllocateDeviceMemoryFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNALLOCATE, MemoryUtil.memAddressSafe(value));
    }

    public static void npfnFree(long struct, @Nullable VmaFreeDeviceMemoryFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNFREE, MemoryUtil.memAddressSafe(value));
    }

    public static void npUserData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PUSERDATA, value);
    }

    static {
        Struct.Layout layout = VmaDeviceMemoryCallbacks.__struct(VmaDeviceMemoryCallbacks.__member(POINTER_SIZE), VmaDeviceMemoryCallbacks.__member(POINTER_SIZE), VmaDeviceMemoryCallbacks.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PFNALLOCATE = layout.offsetof(0);
        PFNFREE = layout.offsetof(1);
        PUSERDATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaDeviceMemoryCallbacks, Buffer>
    implements NativeResource {
        private static final VmaDeviceMemoryCallbacks ELEMENT_FACTORY = VmaDeviceMemoryCallbacks.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VmaDeviceMemoryCallbacks getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="PFN_vmaAllocateDeviceMemoryFunction")
        public @Nullable VmaAllocateDeviceMemoryFunction pfnAllocate() {
            return VmaDeviceMemoryCallbacks.npfnAllocate(this.address());
        }

        @NativeType(value="PFN_vmaFreeDeviceMemoryFunction")
        public @Nullable VmaFreeDeviceMemoryFunction pfnFree() {
            return VmaDeviceMemoryCallbacks.npfnFree(this.address());
        }

        @NativeType(value="void *")
        public long pUserData() {
            return VmaDeviceMemoryCallbacks.npUserData(this.address());
        }

        public Buffer pfnAllocate(@NativeType(value="PFN_vmaAllocateDeviceMemoryFunction") @Nullable VmaAllocateDeviceMemoryFunctionI value) {
            VmaDeviceMemoryCallbacks.npfnAllocate(this.address(), value);
            return this;
        }

        public Buffer pfnFree(@NativeType(value="PFN_vmaFreeDeviceMemoryFunction") @Nullable VmaFreeDeviceMemoryFunctionI value) {
            VmaDeviceMemoryCallbacks.npfnFree(this.address(), value);
            return this;
        }

        public Buffer pUserData(@NativeType(value="void *") long value) {
            VmaDeviceMemoryCallbacks.npUserData(this.address(), value);
            return this;
        }
    }
}

