/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaStatistics
extends Struct<VmaStatistics>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BLOCKCOUNT;
    public static final int ALLOCATIONCOUNT;
    public static final int BLOCKBYTES;
    public static final int ALLOCATIONBYTES;

    protected VmaStatistics(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VmaStatistics create(long address, @Nullable ByteBuffer container) {
        return new VmaStatistics(address, container);
    }

    public VmaStatistics(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaStatistics.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int blockCount() {
        return VmaStatistics.nblockCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int allocationCount() {
        return VmaStatistics.nallocationCount(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long blockBytes() {
        return VmaStatistics.nblockBytes(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long allocationBytes() {
        return VmaStatistics.nallocationBytes(this.address());
    }

    public static VmaStatistics malloc() {
        return new VmaStatistics(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VmaStatistics calloc() {
        return new VmaStatistics(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VmaStatistics create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VmaStatistics(MemoryUtil.memAddress(container), container);
    }

    public static VmaStatistics create(long address) {
        return new VmaStatistics(address, null);
    }

    public static @Nullable VmaStatistics createSafe(long address) {
        return address == 0L ? null : new VmaStatistics(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VmaStatistics.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaStatistics.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VmaStatistics malloc(MemoryStack stack) {
        return new VmaStatistics(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VmaStatistics calloc(MemoryStack stack) {
        return new VmaStatistics(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nblockCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BLOCKCOUNT);
    }

    public static int nallocationCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ALLOCATIONCOUNT);
    }

    public static long nblockBytes(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BLOCKBYTES);
    }

    public static long nallocationBytes(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ALLOCATIONBYTES);
    }

    static {
        Struct.Layout layout = VmaStatistics.__struct(VmaStatistics.__member(4), VmaStatistics.__member(4), VmaStatistics.__member(8), VmaStatistics.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BLOCKCOUNT = layout.offsetof(0);
        ALLOCATIONCOUNT = layout.offsetof(1);
        BLOCKBYTES = layout.offsetof(2);
        ALLOCATIONBYTES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VmaStatistics, Buffer>
    implements NativeResource {
        private static final VmaStatistics ELEMENT_FACTORY = VmaStatistics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VmaStatistics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int blockCount() {
            return VmaStatistics.nblockCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int allocationCount() {
            return VmaStatistics.nallocationCount(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long blockBytes() {
            return VmaStatistics.nblockBytes(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long allocationBytes() {
            return VmaStatistics.nallocationBytes(this.address());
        }
    }
}

