/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaVirtualAllocationInfo
extends Struct<VmaVirtualAllocationInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int SIZE;
    public static final int PUSERDATA;

    protected VmaVirtualAllocationInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VmaVirtualAllocationInfo create(long address, @Nullable ByteBuffer container) {
        return new VmaVirtualAllocationInfo(address, container);
    }

    public VmaVirtualAllocationInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaVirtualAllocationInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VmaVirtualAllocationInfo.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VmaVirtualAllocationInfo.nsize(this.address());
    }

    @NativeType(value="void *")
    public long pUserData() {
        return VmaVirtualAllocationInfo.npUserData(this.address());
    }

    public static VmaVirtualAllocationInfo malloc() {
        return new VmaVirtualAllocationInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VmaVirtualAllocationInfo calloc() {
        return new VmaVirtualAllocationInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VmaVirtualAllocationInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VmaVirtualAllocationInfo(MemoryUtil.memAddress(container), container);
    }

    public static VmaVirtualAllocationInfo create(long address) {
        return new VmaVirtualAllocationInfo(address, null);
    }

    public static @Nullable VmaVirtualAllocationInfo createSafe(long address) {
        return address == 0L ? null : new VmaVirtualAllocationInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VmaVirtualAllocationInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaVirtualAllocationInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VmaVirtualAllocationInfo malloc(MemoryStack stack) {
        return new VmaVirtualAllocationInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VmaVirtualAllocationInfo calloc(MemoryStack stack) {
        return new VmaVirtualAllocationInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static long npUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PUSERDATA);
    }

    static {
        Struct.Layout layout = VmaVirtualAllocationInfo.__struct(VmaVirtualAllocationInfo.__member(8), VmaVirtualAllocationInfo.__member(8), VmaVirtualAllocationInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        PUSERDATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaVirtualAllocationInfo, Buffer>
    implements NativeResource {
        private static final VmaVirtualAllocationInfo ELEMENT_FACTORY = VmaVirtualAllocationInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VmaVirtualAllocationInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VmaVirtualAllocationInfo.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VmaVirtualAllocationInfo.nsize(this.address());
        }

        @NativeType(value="void *")
        public long pUserData() {
            return VmaVirtualAllocationInfo.npUserData(this.address());
        }
    }
}

